/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public final class AIFunctionSettings {
    private boolean functionsEnabled = true;
    private final Set<String> enabledFunctionCategories = new LinkedHashSet<String>();
    private final Set<String> enabledFunctions = new LinkedHashSet<String>();
    private final Set<String> initializedDefaultCategories = new LinkedHashSet<String>();

    AIFunctionSettings() {
    }

    public boolean isFunctionsEnabled() {
        return this.functionsEnabled;
    }

    public void setFunctionsEnabled(boolean functionsEnabled) {
        this.functionsEnabled = functionsEnabled;
    }

    @NotNull
    public Set<String> getEnabledFunctions() {
        return Set.copyOf(this.enabledFunctions);
    }

    public void setEnabledFunctions(@Nullable Set<String> functions) {
        this.enabledFunctions.clear();
        if (functions != null) {
            this.enabledFunctions.addAll(functions);
        }
    }

    public boolean isFunctionEnabled(@NotNull String functionId) {
        return this.enabledFunctions.contains(functionId);
    }

    public void enableFunction(@NotNull String functionId) {
        this.enabledFunctions.add(functionId);
    }

    public void disableFunction(@NotNull String functionId) {
        this.enabledFunctions.remove(functionId);
    }

    @NotNull
    public Set<String> getEnabledFunctionCategories() {
        return new HashSet<String>(this.enabledFunctionCategories);
    }

    public void setEnabledFunctionCategories(@Nullable Set<String> categories) {
        this.enabledFunctionCategories.clear();
        if (categories != null) {
            this.enabledFunctionCategories.addAll(categories);
        }
    }

    public boolean isFunctionCategoryEnabled(@NotNull String category) {
        return this.enabledFunctionCategories.contains(category);
    }

    public void enableFunctionCategory(@NotNull String category) {
        this.enabledFunctionCategories.add(category);
    }

    public void disableFunctionCategory(@NotNull String category) {
        this.enabledFunctionCategories.remove(category);
    }

    @NotNull
    public Set<String> getInitializedDefaultCategories() {
        return new HashSet<String>(this.initializedDefaultCategories);
    }

    public void setInitializedDefaultCategories(@Nullable Set<String> categories) {
        this.initializedDefaultCategories.clear();
        if (categories != null) {
            this.initializedDefaultCategories.addAll(categories);
        }
    }

    public void markCategoryAsInitialized(@NotNull String categoryId) {
        this.initializedDefaultCategories.add(categoryId);
    }

    public boolean isCategoryInitialized(@NotNull String categoryId) {
        return this.initializedDefaultCategories.contains(categoryId);
    }
}

