/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.hints.standard;

import java.util.EnumSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.hints.DBDAttributeHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.ValueHintText;
import org.jkiss.dbeaver.model.exec.DBExecUtils;

public class AttributeStatusHintProvider
implements DBDAttributeHintProvider {
    @Override
    @Nullable
    public DBDValueHint[] getAttributeHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        DBPDataSource dataSource = attribute.getDataSource();
        String readOnlyStatus = model.getReadOnlyStatus(dataSource == null ? null : dataSource.getContainer());
        if (readOnlyStatus == null) {
            readOnlyStatus = DBExecUtils.getAttributeReadOnlyStatus(attribute, true);
        }
        if (readOnlyStatus != null) {
            return new DBDValueHint[]{new ValueHintReadOnly("Read-only: " + readOnlyStatus)};
        }
        return null;
    }

    static class ValueHintReadOnly
    extends ValueHintText {
        public ValueHintReadOnly(@NotNull String text) {
            super(text, null, null);
        }

        @Override
        public int getHintOptions() {
            return 1;
        }
    }
}

