﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/bedrock-agent/model/FlowNodeIODataType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {

/**
 * <p>Contains configurations for an output from a node.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/FlowNodeOutput">AWS
 * API Reference</a></p>
 */
class FlowNodeOutput {
 public:
  AWS_BEDROCKAGENT_API FlowNodeOutput() = default;
  AWS_BEDROCKAGENT_API FlowNodeOutput(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API FlowNodeOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A name for the output that you can reference.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  FlowNodeOutput& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data type of the output. If the output doesn't match this type at
   * runtime, a validation error will be thrown.</p>
   */
  inline FlowNodeIODataType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(FlowNodeIODataType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline FlowNodeOutput& WithType(FlowNodeIODataType value) {
    SetType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  FlowNodeIODataType m_type{FlowNodeIODataType::NOT_SET};
  bool m_nameHasBeenSet = false;
  bool m_typeHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
