/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ErrorCause
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ErrorCause> {
    @Nullable
    private final ErrorCause causedBy;
    @Nonnull
    private final Map<String, List<String>> header;
    @Nonnull
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String reason;
    @Nonnull
    private final List<ErrorCause> rootCause;
    @Nullable
    private final String stackTrace;
    @Nonnull
    private final List<ErrorCause> suppressed;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<ErrorCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorCause::setupErrorCauseDeserializer);

    private ErrorCause(Builder builder) {
        this.causedBy = builder.causedBy;
        this.header = ApiTypeHelper.unmodifiable(builder.header);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.reason = builder.reason;
        this.rootCause = ApiTypeHelper.unmodifiable(builder.rootCause);
        this.stackTrace = builder.stackTrace;
        this.suppressed = ApiTypeHelper.unmodifiable(builder.suppressed);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ErrorCause of(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ErrorCause causedBy() {
        return this.causedBy;
    }

    @Nonnull
    public final Map<String, List<String>> header() {
        return this.header;
    }

    @Nonnull
    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Nonnull
    public final List<ErrorCause> rootCause() {
        return this.rootCause;
    }

    @Nullable
    public final String stackTrace() {
        return this.stackTrace;
    }

    @Nonnull
    public final List<ErrorCause> suppressed() {
        return this.suppressed;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        if (this.causedBy != null) {
            generator.writeKey("caused_by");
            this.causedBy.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.header)) {
            generator.writeKey("header");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.header.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (ApiTypeHelper.isDefined(this.rootCause)) {
            generator.writeKey("root_cause");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.rootCause) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.stackTrace != null) {
            generator.writeKey("stack_trace");
            generator.write(this.stackTrace);
        }
        if (ApiTypeHelper.isDefined(this.suppressed)) {
            generator.writeKey("suppressed");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.suppressed) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupErrorCauseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::causedBy, _DESERIALIZER, "caused_by");
        op.add(Builder::header, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "header");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::rootCause, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "root_cause");
        op.add(Builder::stackTrace, JsonpDeserializer.stringDeserializer(), "stack_trace");
        op.add(Builder::suppressed, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "suppressed");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.causedBy);
        result = 31 * result + Objects.hashCode(this.header);
        result = 31 * result + Objects.hashCode(this.metadata);
        result = 31 * result + Objects.hashCode(this.reason);
        result = 31 * result + Objects.hashCode(this.rootCause);
        result = 31 * result + Objects.hashCode(this.stackTrace);
        result = 31 * result + Objects.hashCode(this.suppressed);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorCause other = (ErrorCause)o;
        return Objects.equals(this.causedBy, other.causedBy) && Objects.equals(this.header, other.header) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.reason, other.reason) && Objects.equals(this.rootCause, other.rootCause) && Objects.equals(this.stackTrace, other.stackTrace) && Objects.equals(this.suppressed, other.suppressed) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ErrorCause> {
        @Nullable
        private ErrorCause causedBy;
        @Nullable
        private Map<String, List<String>> header;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String reason;
        @Nullable
        private List<ErrorCause> rootCause;
        @Nullable
        private String stackTrace;
        @Nullable
        private List<ErrorCause> suppressed;
        private String type;

        public Builder() {
        }

        private Builder(ErrorCause o) {
            this.causedBy = o.causedBy;
            this.header = Builder._mapCopy(o.header);
            this.metadata = Builder._mapCopy(o.metadata);
            this.reason = o.reason;
            this.rootCause = Builder._listCopy(o.rootCause);
            this.stackTrace = o.stackTrace;
            this.suppressed = Builder._listCopy(o.suppressed);
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.causedBy = o.causedBy;
            this.header = Builder._mapCopy(o.header);
            this.metadata = Builder._mapCopy(o.metadata);
            this.reason = o.reason;
            this.rootCause = Builder._listCopy(o.rootCause);
            this.stackTrace = o.stackTrace;
            this.suppressed = Builder._listCopy(o.suppressed);
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder causedBy(@Nullable ErrorCause value) {
            this.causedBy = value;
            return this;
        }

        @Nonnull
        public final Builder causedBy(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.causedBy(fn.apply(new Builder()).build());
        }

        @Nonnull
        public final Builder header(Map<String, List<String>> map) {
            this.header = Builder._mapPutAll(this.header, map);
            return this;
        }

        @Nonnull
        public final Builder header(String key, List<String> value) {
            this.header = Builder._mapPut(this.header, key, value);
            return this;
        }

        @Nonnull
        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        @Nonnull
        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Nonnull
        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Nonnull
        public final Builder rootCause(List<ErrorCause> list) {
            this.rootCause = Builder._listAddAll(this.rootCause, list);
            return this;
        }

        @Nonnull
        public final Builder rootCause(ErrorCause value, ErrorCause ... values) {
            this.rootCause = Builder._listAdd(this.rootCause, value, values);
            return this;
        }

        @Nonnull
        public final Builder rootCause(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.rootCause(fn.apply(new Builder()).build(), new ErrorCause[0]);
        }

        @Nonnull
        public final Builder stackTrace(@Nullable String value) {
            this.stackTrace = value;
            return this;
        }

        @Nonnull
        public final Builder suppressed(List<ErrorCause> list) {
            this.suppressed = Builder._listAddAll(this.suppressed, list);
            return this;
        }

        @Nonnull
        public final Builder suppressed(ErrorCause value, ErrorCause ... values) {
            this.suppressed = Builder._listAdd(this.suppressed, value, values);
            return this;
        }

        @Nonnull
        public final Builder suppressed(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.suppressed(fn.apply(new Builder()).build(), new ErrorCause[0]);
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public ErrorCause build() {
            this._checkSingleUse();
            return new ErrorCause(this);
        }
    }
}

