/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.lib.exceptions.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.AndExpression;
import org.osgi.service.repository.ExpressionCombiner;
import org.osgi.service.repository.IdentityExpression;
import org.osgi.service.repository.NotExpression;
import org.osgi.service.repository.OrExpression;
import org.osgi.service.repository.Repository;
import org.osgi.service.repository.RequirementBuilder;
import org.osgi.service.repository.RequirementExpression;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public abstract class BaseRepository
implements Repository {
    private static final RequirementExpression[] EMPTY = new RequirementExpression[0];
    static IdentityExpression all;
    private final PromiseFactory promiseFactory = new PromiseFactory(PromiseFactory.inlineExecutor());

    public Promise<Collection<Resource>> findProviders(RequirementExpression expression) {
        HashSet<Resource> providers = new HashSet<Resource>();
        this.dispatch(expression, providers);
        return this.promiseFactory.resolved(providers);
    }

    private void dispatch(RequirementExpression expression, Set<Resource> providers) {
        if (expression instanceof IdentityExpression) {
            Map capabilities = this.findProviders(Collections.singleton(((IdentityExpression)expression).getRequirement()));
            for (Collection caps : capabilities.values()) {
                for (Capability c : caps) {
                    providers.add(c.getResource());
                }
            }
        } else if (expression instanceof OrExpression) {
            for (RequirementExpression re : ((OrExpression)expression).getRequirementExpressions()) {
                this.dispatch(re, providers);
            }
        } else if (expression instanceof AndExpression) {
            List requirementExpressions = ((AndExpression)expression).getRequirementExpressions();
            if (requirementExpressions.isEmpty()) {
                return;
            }
            if (requirementExpressions.size() == 1) {
                this.dispatch((RequirementExpression)requirementExpressions.get(0), providers);
                return;
            }
            HashSet<Resource> subset = new HashSet<Resource>();
            this.dispatch((RequirementExpression)requirementExpressions.get(0), subset);
            for (int i = 1; i < requirementExpressions.size(); ++i) {
                Iterator it = subset.iterator();
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    RequirementExpression re = (RequirementExpression)requirementExpressions.get(i);
                    if (this.matches(re, resource)) continue;
                    it.remove();
                    if (!subset.isEmpty()) continue;
                    return;
                }
            }
            providers.addAll(subset);
        } else if (expression instanceof NotExpression) {
            HashSet<Resource> allSet = new HashSet<Resource>();
            this.dispatch((RequirementExpression)all, allSet);
            RequirementExpression re = ((NotExpression)expression).getRequirementExpression();
            Iterator it = allSet.iterator();
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!this.matches(re, resource)) continue;
                it.remove();
                if (!allSet.isEmpty()) continue;
                return;
            }
            providers.addAll(allSet);
        } else {
            throw new UnsupportedOperationException("Unknown expression type " + expression.getClass());
        }
    }

    private boolean matches(RequirementExpression expression, Resource resource) {
        if (expression instanceof IdentityExpression) {
            Requirement r = ((IdentityExpression)expression).getRequirement();
            return ResourceUtils.matches(r, resource);
        }
        if (expression instanceof OrExpression) {
            List res = ((OrExpression)expression).getRequirementExpressions();
            for (RequirementExpression re : res) {
                if (!this.matches(re, resource)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof AndExpression) {
            List res = ((AndExpression)expression).getRequirementExpressions();
            for (RequirementExpression re : res) {
                if (this.matches(re, resource)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof NotExpression) {
            RequirementExpression re = ((NotExpression)expression).getRequirementExpression();
            return !this.matches(re, resource);
        }
        throw new UnsupportedOperationException("Unknown expression type " + expression.getClass());
    }

    public ExpressionCombiner getExpressionCombiner() {
        return new ExpressionCombiner(){

            public OrExpression or(RequirementExpression expr1, RequirementExpression expr2, RequirementExpression ... moreExprs) {
                List<RequirementExpression> exprs = this.combine(expr1, expr2, moreExprs);
                return () -> exprs;
            }

            List<RequirementExpression> combine(RequirementExpression expr1, RequirementExpression expr2, RequirementExpression ... moreExprs) {
                ArrayList<RequirementExpression> exprs = new ArrayList<RequirementExpression>();
                exprs = new ArrayList();
                exprs.add(expr1);
                exprs.add(expr2);
                Collections.addAll(exprs, moreExprs);
                return Collections.unmodifiableList(exprs);
            }

            public OrExpression or(RequirementExpression expr1, RequirementExpression expr2) {
                return this.or(expr1, expr2, EMPTY);
            }

            public NotExpression not(RequirementExpression expr) {
                return () -> expr;
            }

            public IdentityExpression identity(Requirement req) {
                return () -> req;
            }

            public AndExpression and(RequirementExpression expr1, RequirementExpression expr2, RequirementExpression ... moreExprs) {
                List<RequirementExpression> exprs = this.combine(expr1, expr2, moreExprs);
                return () -> exprs;
            }

            public AndExpression and(RequirementExpression expr1, RequirementExpression expr2) {
                return this.and(expr1, expr2, EMPTY);
            }
        };
    }

    public RequirementBuilder newRequirementBuilder(String namespace) {
        final aQute.bnd.osgi.resource.RequirementBuilder rb = new aQute.bnd.osgi.resource.RequirementBuilder(namespace);
        return new RequirementBuilder(){

            public RequirementBuilder setResource(Resource resource) {
                rb.setResource(resource);
                return this;
            }

            public RequirementBuilder setDirectives(Map<String, String> directives) {
                rb.addDirectives(directives);
                return this;
            }

            public RequirementBuilder setAttributes(Map<String, Object> attributes) {
                try {
                    rb.addAttributes(attributes);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
                return this;
            }

            public IdentityExpression buildExpression() {
                return this::build;
            }

            public Requirement build() {
                if (rb.getResource() == null) {
                    return rb.buildSyntheticRequirement();
                }
                return rb.buildRequirement();
            }

            public RequirementBuilder addDirective(String name, String value) {
                rb.addDirective(name, value);
                return this;
            }

            public RequirementBuilder addAttribute(String name, Object value) {
                try {
                    rb.addAttribute(name, value);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
                return this;
            }
        };
    }

    static {
        Requirement requireAll = ResourceUtils.createWildcardRequirement();
        all = () -> requireAll;
    }
}

