/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging;

import java.util.HashMap;
import java.util.Map;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.TrackingLogger;
import org.ops4j.pax.logging.spi.support.BundleHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGIPaxLoggingManager
implements PaxLoggingManager,
ServiceTrackerCustomizer<PaxLoggingService, PaxLoggingService> {
    private ServiceTracker<PaxLoggingService, PaxLoggingService> tracker;
    private PaxLoggingService m_logService;
    private ServiceReference<PaxLoggingService> m_logServiceRef;
    private final Map<String, TrackingLogger> m_loggers;
    private BundleContext m_context;

    public OSGIPaxLoggingManager(BundleContext context) {
        this.tracker = new ServiceTracker(context, PaxLoggingService.class.getName(), (ServiceTrackerCustomizer)this);
        this.m_loggers = new HashMap<String, TrackingLogger>();
        this.m_context = context;
        this.tracker.open();
        ServiceReference ref = this.tracker.getServiceReference();
        if (ref != null) {
            this.m_logService = (PaxLoggingService)context.getService(ref);
        }
    }

    @Override
    public PaxLogger getLogger(String category, String fqcn) {
        Bundle bundle = BundleHelper.getCallerBundle(this.m_context.getBundle());
        return this.getLogger(bundle, category, fqcn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        if (fqcn == null) {
            fqcn = PaxLogger.class.getName();
        }
        String key = fqcn + "#" + category + "#" + (bundle != null ? Long.toString(bundle.getBundleId()) : "0");
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            TrackingLogger logger = this.m_loggers.get(key);
            if (logger == null) {
                logger = new TrackingLogger(this.m_logService, category, bundle, fqcn);
                this.m_loggers.put(key, logger);
            }
            return logger;
        }
    }

    @Override
    public PaxLoggingService getPaxLoggingService() {
        return this.m_logService;
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.m_logServiceRef != null) {
            this.m_context.ungetService(this.m_logServiceRef);
            this.m_logServiceRef = null;
        }
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            for (TrackingLogger logger : this.m_loggers.values()) {
                logger.removed();
            }
            this.m_loggers.clear();
        }
        this.m_context = null;
    }

    @Override
    public Bundle getBundle() {
        return this.m_context.getBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaxLoggingService addingService(ServiceReference<PaxLoggingService> reference) {
        this.m_logServiceRef = reference;
        this.m_logService = (PaxLoggingService)this.m_context.getService(this.m_logServiceRef);
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            for (TrackingLogger logger : this.m_loggers.values()) {
                logger.added(this.m_logService);
            }
        }
        return this.m_logService;
    }

    public void modifiedService(ServiceReference<PaxLoggingService> reference, PaxLoggingService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<PaxLoggingService> reference, PaxLoggingService service) {
        this.m_logService = null;
        if (this.m_logServiceRef != null) {
            this.m_context.ungetService(this.m_logServiceRef);
            this.m_logServiceRef = null;
        }
        Map<String, TrackingLogger> map = this.m_loggers;
        synchronized (map) {
            for (TrackingLogger logger : this.m_loggers.values()) {
                logger.removed();
            }
        }
    }
}

