/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomee.catalina.TomcatSecurityService;

public class OpenEJBSecurityListener
implements AsyncListener {
    public static final ThreadLocal<Request> requests = new ThreadLocal();
    private TomcatSecurityService securityService;
    private Object oldState;
    private Request request;

    public OpenEJBSecurityListener(TomcatSecurityService service, Request req) {
        this.securityService = service;
        this.request = req;
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.asyncExit();
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
        this.asyncExit();
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        asyncEvent.getAsyncContext().addListener((AsyncListener)this);
        requests.set(this.request);
        this.enter();
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        this.asyncExit();
    }

    private void asyncExit() {
        try {
            this.exit();
        }
        finally {
            requests.remove();
        }
    }

    public void enter() {
        if (this.securityService != null && this.request.getWrapper() != null) {
            this.oldState = this.securityService.enterWebApp(this.request.getWrapper().getRealm(), this.request.getPrincipal(), this.request.getWrapper().getRunAs());
        }
    }

    public void exit() {
        if (this.securityService != null) {
            this.securityService.exitWebApp(this.oldState);
        }
    }

    public static class RequestCapturer
    extends ValveBase {
        public RequestCapturer() {
            super(true);
        }

        protected synchronized void startInternal() throws LifecycleException {
            super.startInternal();
        }

        public void invoke(Request request, Response response) throws IOException, ServletException {
            requests.set(request);
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                requests.remove();
            }
        }
    }
}

