/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClientBehaviorRedirectEventComponentWrapper
extends UIComponent
implements FacesWrapper<UIComponent>,
ClientBehaviorHolder {
    private final UIComponent composite;
    private final UIComponent delegate;
    private final String sourceEvent;
    private final String targetEvent;
    private final ValueExpression targets;

    public ClientBehaviorRedirectEventComponentWrapper(UIComponent composite, UIComponent delegate, String sourceEvent, String targetEvent, ValueExpression targets) {
        this.composite = composite;
        this.delegate = delegate;
        this.sourceEvent = sourceEvent;
        this.targetEvent = targetEvent;
        this.targets = targets;
    }

    public UIComponent getWrapped() {
        return this.delegate;
    }

    public void addClientBehavior(String eventName, ClientBehavior behavior) {
        if (this.sourceEvent.equals(eventName)) {
            String targetEventName = this.targetEvent == null ? ((ClientBehaviorHolder)this.delegate).getDefaultEventName() : this.targetEvent;
            ((ClientBehaviorHolder)this.delegate).addClientBehavior(targetEventName, behavior);
        }
    }

    public Map<String, List<ClientBehavior>> getClientBehaviors() {
        HashMap<String, List> clientBehaviors = new HashMap<String, List>(1);
        clientBehaviors.put(this.sourceEvent, (List)((ClientBehaviorHolder)this.delegate).getClientBehaviors().get(this.targetEvent));
        return Collections.unmodifiableMap(clientBehaviors);
    }

    public String getDefaultEventName() {
        if (this.targetEvent == null) {
            if (((ClientBehaviorHolder)this.delegate).getDefaultEventName() != null) {
                return this.sourceEvent;
            }
            return null;
        }
        return this.sourceEvent;
    }

    public Collection<String> getEventNames() {
        return Collections.singletonList(this.sourceEvent);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        this.delegate.broadcast(event);
    }

    public void clearInitialState() {
        this.delegate.clearInitialState();
    }

    public void decode(FacesContext context) {
        this.delegate.decode(context);
    }

    public void encodeAll(FacesContext context) throws IOException {
        this.delegate.encodeAll(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.delegate.encodeBegin(context);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.delegate.encodeChildren(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.delegate.encodeEnd(context);
    }

    public UIComponent findComponent(String expr) {
        return this.delegate.findComponent(expr);
    }

    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }

    public int getChildCount() {
        return this.delegate.getChildCount();
    }

    public List<UIComponent> getChildren() {
        return this.delegate.getChildren();
    }

    public String getClientId() {
        return this.delegate.getClientId();
    }

    public String getClientId(FacesContext context) {
        return this.delegate.getClientId(context);
    }

    public String getContainerClientId(FacesContext ctx) {
        return this.delegate.getContainerClientId(ctx);
    }

    public UIComponent getFacet(String name) {
        return this.delegate.getFacet(name);
    }

    public int getFacetCount() {
        return this.delegate.getFacetCount();
    }

    public Map<String, UIComponent> getFacets() {
        return this.delegate.getFacets();
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        return this.delegate.getFacetsAndChildren();
    }

    public String getFamily() {
        return this.delegate.getFamily();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        return this.delegate.getListenersForEventClass(eventClass);
    }

    public UIComponent getNamingContainer() {
        return this.delegate.getNamingContainer();
    }

    public UIComponent getParent() {
        return this.delegate.getParent();
    }

    public String getRendererType() {
        return this.delegate.getRendererType();
    }

    public boolean getRendersChildren() {
        return this.delegate.getRendersChildren();
    }

    public Map<String, String> getResourceBundleMap() {
        return this.delegate.getResourceBundleMap();
    }

    public ValueExpression getValueExpression(String name) {
        return this.delegate.getValueExpression(name);
    }

    public boolean initialStateMarked() {
        return this.delegate.initialStateMarked();
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        return this.delegate.invokeOnComponent(context, clientId, callback);
    }

    public boolean isInView() {
        return this.delegate.isInView();
    }

    public boolean isRendered() {
        return this.delegate.isRendered();
    }

    public boolean isTransient() {
        return this.delegate.isTransient();
    }

    public void markInitialState() {
        this.delegate.markInitialState();
    }

    public void processDecodes(FacesContext context) {
        this.delegate.processDecodes(context);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        this.delegate.processEvent(event);
    }

    public void processRestoreState(FacesContext context, Object state) {
        this.delegate.processRestoreState(context, state);
    }

    public Object processSaveState(FacesContext context) {
        return this.delegate.processSaveState(context);
    }

    public void processUpdates(FacesContext context) {
        this.delegate.processUpdates(context);
    }

    public void processValidators(FacesContext context) {
        this.delegate.processValidators(context);
    }

    public void queueEvent(FacesEvent event) {
        this.delegate.queueEvent(event);
    }

    public void restoreState(FacesContext context, Object state) {
        this.delegate.restoreState(context, state);
    }

    public Object saveState(FacesContext context) {
        return this.delegate.saveState(context);
    }

    public void setId(String id) {
        this.delegate.setId(id);
    }

    public void setInView(boolean isInView) {
        this.delegate.setInView(isInView);
    }

    public void setParent(UIComponent parent) {
        this.delegate.setParent(parent);
    }

    public void setRendered(boolean rendered) {
        this.delegate.setRendered(rendered);
    }

    public void setRendererType(String rendererType) {
        this.delegate.setRendererType(rendererType);
    }

    public void setTransient(boolean newTransientValue) {
        this.delegate.setTransient(newTransientValue);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        this.delegate.setValueExpression(name, expression);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        this.delegate.subscribeToEvent(eventClass, componentListener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        this.delegate.unsubscribeFromEvent(eventClass, componentListener);
    }

    public boolean visitTree(VisitContext context, VisitCallback callback) {
        return this.delegate.visitTree(context, callback);
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected void addFacesListener(FacesListener listener) {
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        return null;
    }

    protected Renderer getRenderer(FacesContext context) {
        return null;
    }

    protected void removeFacesListener(FacesListener listener) {
    }

    public Map<String, Object> getPassThroughAttributes(boolean create) {
        return this.getWrapped().getPassThroughAttributes(create);
    }

    public UIComponent getComposite() {
        return this.composite;
    }

    public UIComponent getDelegate() {
        return this.delegate;
    }

    public ValueExpression getTargets() {
        return this.targets;
    }
}

