/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;

public class AddProxyRestrictionToAssertions
extends AbstractConditionalProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddProxyRestrictionToAssertions.class);
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = new MessageLookup(Response.class).compose((Function)new OutboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, Pair<Integer, Set<String>>> proxyRestrictionLookupStrategy;
    @NonnullBeforeExec
    private Response response;
    @Nullable
    private Integer proxyCount;
    @Nullable
    private Set<String> audiences;

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setProxyRestrictionLookupStrategy(@Nonnull Function<ProfileRequestContext, Pair<Integer, Set<String>>> strategy) {
        this.checkSetterPreconditions();
        this.proxyRestrictionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Proxy restriction lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.proxyRestrictionLookupStrategy == null) {
            throw new ComponentInitializationException("Proxy restriction lookup strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Pair<Integer, Set<String>> result = this.proxyRestrictionLookupStrategy.apply(profileRequestContext);
        if (result != null) {
            this.proxyCount = (Integer)result.getFirst();
            this.audiences = (Set)result.getSecond();
            if (this.audiences != null && this.audiences.isEmpty()) {
                this.audiences = null;
            }
        }
        if (this.proxyCount == null && this.audiences == null) {
            this.log.debug("{} No restrictions to add, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.log.debug("{} Attempting to add an ProxyRestriction to every Assertion in Response", (Object)this.getLogPrefix());
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No response located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (this.response.getAssertions().isEmpty()) {
            this.log.debug("{} No assertions found in response, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (Assertion assertion : this.response.getAssertions()) {
            assert (assertion != null);
            this.addProxyRestriction(profileRequestContext, SAML2ActionSupport.addConditionsToAssertion((AbstractProfileAction)this, (Assertion)assertion));
            this.log.debug("{} Added ProxyRestriction to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
    }

    private void addProxyRestriction(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Conditions conditions) {
        ProxyRestriction condition = this.getProxyRestriction(conditions);
        condition.setProxyCount(this.proxyCount);
        if (this.proxyCount != null && this.proxyCount == 0) {
            return;
        }
        if (this.audiences != null && !this.audiences.isEmpty()) {
            SAMLObjectBuilder audienceBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Audience.DEFAULT_ELEMENT_NAME);
            assert (this.audiences != null);
            for (String audienceId : this.audiences) {
                this.log.debug("{} Adding {} as an Audience of the ProxyRestriction", (Object)this.getLogPrefix(), (Object)audienceId);
                Audience audience = (Audience)audienceBuilder.buildObject();
                audience.setURI(audienceId);
                condition.getAudiences().add(audience);
            }
        }
    }

    @Nonnull
    private ProxyRestriction getProxyRestriction(@Nonnull Conditions conditions) {
        ProxyRestriction condition = conditions.getProxyRestriction();
        if (condition == null) {
            SAMLObjectBuilder conditionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(ProxyRestriction.DEFAULT_ELEMENT_NAME);
            this.log.debug("{} Adding new ProxyRestriction", (Object)this.getLogPrefix());
            condition = (ProxyRestriction)conditionBuilder.buildObject();
            conditions.getConditions().add(condition);
        } else {
            this.log.debug("{} Conditions already contained an ProxyRestriction, using it", (Object)this.getLogPrefix());
        }
        return condition;
    }
}

