/**
 * @author Jorge Bay Gondra
 */
import { EnumValue, Traversal } from './traversal.cjs';
import { Transaction } from './transaction.cjs';
import Bytecode from './bytecode.cjs';
import { TraversalStrategies } from './traversal-strategy.cjs';
import { Graph } from '../structure/graph.cjs';
import { RemoteConnection } from '../driver/remote-connection.cjs';
/**
 * Represents the primary DSL of the Gremlin traversal machine.
 */
export declare class GraphTraversalSource {
    graph: Graph;
    traversalStrategies: TraversalStrategies;
    bytecode: Bytecode;
    graphTraversalSourceClass: typeof GraphTraversalSource;
    graphTraversalClass: typeof GraphTraversal;
    remoteConnection?: RemoteConnection;
    /**
     * Creates a new instance of {@link GraphTraversalSource}.
     * @param {Graph} graph
     * @param {TraversalStrategies} traversalStrategies
     * @param {Bytecode} [bytecode]
     * @param {Function} [graphTraversalSourceClass] Optional {@link GraphTraversalSource} constructor.
     * @param {Function} [graphTraversalClass] Optional {@link GraphTraversal} constructor.
     */
    constructor(graph: Graph, traversalStrategies: TraversalStrategies, bytecode?: Bytecode, graphTraversalSourceClass?: typeof GraphTraversalSource, graphTraversalClass?: typeof GraphTraversal);
    /**
     * Spawn a new <code>Transaction</code> object that can then start and stop a transaction.
     * @returns {Transaction}
     */
    tx(): Transaction;
    /**
     * @param graphComputer
     * @param workers
     * @param result
     * @param persist
     * @param vertices
     * @param edges
     * @param configuration
     * @returns {GraphTraversalSource}
     */
    withComputer(graphComputer: any, workers: any, result: any, persist: any, vertices: any[], edges: any[], configuration: any): GraphTraversalSource;
    /**
     * Graph Traversal Source with method.
     * @param {String} key
     * @param {Object} value if not specified, the value with default to {@code true}
     * @returns {GraphTraversalSource}
     */
    with_(key: string, value?: object | undefined): GraphTraversalSource;
    /**
     * Returns the string representation of the GraphTraversalSource.
     * @returns {string}
     */
    toString(): string;
    /**
     * Graph Traversal Source withBulk method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withBulk(...args: any[]): GraphTraversalSource;
    /**
     * Graph Traversal Source withPath method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withPath(...args: any[]): GraphTraversalSource;
    /**
     * Graph Traversal Source withSack method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withSack(...args: any[]): GraphTraversalSource;
    /**
     * Graph Traversal Source withSideEffect method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withSideEffect(...args: any[]): GraphTraversalSource;
    /**
     * Graph Traversal Source withStrategies method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withStrategies(...args: any[]): GraphTraversalSource;
    /**
     * Graph Traversal Source withoutStrategies method.
     * @param {...Object} args
     * @returns {GraphTraversalSource}
     */
    withoutStrategies(...args: any[]): GraphTraversalSource;
    /**
     * E GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    E(...args: any[]): GraphTraversal;
    /**
     * V GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    V(...args: any[]): GraphTraversal;
    /**
     * addE GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    addE(...args: any[]): GraphTraversal;
    /**
     * mergeV GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    mergeE(...args: any[]): GraphTraversal;
    /**
     * addV GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    addV(...args: any[]): GraphTraversal;
    /**
     * mergeV GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    mergeV(...args: any[]): GraphTraversal;
    /**
     * inject GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    inject(...args: any[]): GraphTraversal;
    /**
     * io GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    io(...args: any[]): GraphTraversal;
    /**
     * call GraphTraversalSource step method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    call(...args: any[]): GraphTraversal;
    /**
     * union GraphTraversalSource method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    union(...args: any[]): GraphTraversal;
}
/**
 * Represents a graph traversal.
 */
export declare class GraphTraversal extends Traversal {
    constructor(graph: Graph | null, traversalStrategies: TraversalStrategies | null, bytecode: Bytecode);
    /**
     * Copy a traversal so as to reset and re-use it.
     */
    clone(): GraphTraversal;
    /**
     * Graph traversal V method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    V(...args: any[]): this;
    /**
     * Graph traversal E method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    E(...args: any[]): this;
    /**
     * Graph traversal addE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    addE(...args: any[]): this;
    /**
     * Graph traversal addV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    addV(...args: any[]): this;
    /**
     * Graph traversal aggregate method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    aggregate(...args: any[]): this;
    /**
     * Graph traversal all method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    all(...args: any[]): this;
    /**
     * Graph traversal and method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    and(...args: any[]): this;
    /**
     * Graph traversal any method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    any(...args: any[]): this;
    /**
     * Graph traversal as method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    as(...args: any[]): this;
    /**
     * Graph traversal asDate method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    asDate(...args: any[]): this;
    /**
     * Graph traversal asString method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    asString(...args: any[]): this;
    /**
     * Graph traversal barrier method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    barrier(...args: any[]): this;
    /**
     * Graph traversal both method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    both(...args: any[]): this;
    /**
     * Graph traversal bothE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    bothE(...args: any[]): this;
    /**
     * Graph traversal bothV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    bothV(...args: any[]): this;
    /**
     * Graph traversal branch method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    branch(...args: any[]): this;
    /**
     * Graph traversal by method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    by(...args: any[]): this;
    /**
     * Graph traversal call method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    call(...args: any[]): this;
    /**
     * Graph traversal cap method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    cap(...args: any[]): this;
    /**
     * Graph traversal choose method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    choose(...args: any[]): this;
    /**
     * Graph traversal coalesce method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    coalesce(...args: any[]): this;
    /**
     * Graph traversal coin method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    coin(...args: any[]): this;
    /**
     * Graph traversal combine method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    combine(...args: any[]): this;
    /**
     * Graph traversal concat method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    concat(...args: any[]): this;
    /**
     * Graph traversal conjoin method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    conjoin(...args: any[]): this;
    /**
     * Graph traversal connectedComponent method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    connectedComponent(...args: any[]): this;
    /**
     * Graph traversal constant method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    constant(...args: any[]): this;
    /**
     * Graph traversal count method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    count(...args: any[]): this;
    /**
     * Graph traversal cyclicPath method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    cyclicPath(...args: any[]): this;
    /**
     * Graph traversal dateAdd method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    dateAdd(...args: any[]): this;
    /**
     * Graph traversal dateDiff method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    dateDiff(...args: any[]): this;
    /**
     * Graph traversal dedup method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    dedup(...args: any[]): this;
    /**
     * Graph traversal difference method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    difference(...args: any[]): this;
    /**
     * Graph traversal discard method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    discard(...args: any[]): this;
    /**
     * Graph traversal disjunct method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    disjunct(...args: any[]): this;
    /**
     * Graph traversal drop method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    drop(...args: any[]): this;
    /**
     * Graph traversal element method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    element(...args: any[]): this;
    /**
     * Graph traversal elementMap method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    elementMap(...args: any[]): this;
    /**
     * Graph traversal emit method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    emit(...args: any[]): this;
    /**
     * Graph traversal fa method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    fail(...args: any[]): this;
    /**
     * Graph traversal filter method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    filter(...args: any[]): this;
    /**
     * Graph traversal flatMap method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    flatMap(...args: any[]): this;
    /**
     * Graph traversal fold method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    fold(...args: any[]): this;
    /**
     * Graph traversal format method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    format(...args: any[]): this;
    /**
     * Graph traversal from method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    from_(...args: any[]): this;
    /**
     * Graph traversal group method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    group(...args: any[]): this;
    /**
     * Graph traversal groupCount method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    groupCount(...args: any[]): this;
    /**
     * Graph traversal has method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    has(...args: any[]): this;
    /**
     * Graph traversal hasId method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    hasId(...args: any[]): this;
    /**
     * Graph traversal hasKey method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    hasKey(...args: any[]): this;
    /**
     * Graph traversal hasLabel method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    hasLabel(...args: any[]): this;
    /**
     * Graph traversal hasNot method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    hasNot(...args: any[]): this;
    /**
     * Graph traversal hasValue method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    hasValue(...args: any[]): this;
    /**
     * Graph traversal id method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    id(...args: any[]): this;
    /**
     * Graph traversal identity method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    identity(...args: any[]): this;
    /**
     * Graph traversal in method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    in_(...args: any[]): this;
    /**
     * Graph traversal inE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    inE(...args: any[]): this;
    /**
     * Graph traversal inV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    inV(...args: any[]): this;
    /**
     * Graph traversal index method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    index(...args: any[]): this;
    /**
     * Graph traversal inject method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    inject(...args: any[]): this;
    /**
     * Graph traversal intersect method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    intersect(...args: any[]): this;
    /**
     * Graph traversal is method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    is(...args: any[]): this;
    /**
     * Graph traversal key method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    key(...args: any[]): this;
    /**
     * Graph traversal label method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    label(...args: any[]): this;
    /**
     * Graph traversal length method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    length(...args: any[]): this;
    /**
     * Graph traversal limit method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    limit(...args: any[]): this;
    /**
     * Graph traversal local method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    local(...args: any[]): this;
    /**
     * Graph traversal loops method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    loops(...args: any[]): this;
    /**
     * Graph traversal lTrim method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    lTrim(...args: any[]): this;
    /**
     * Graph traversal map method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    map(...args: any[]): this;
    /**
     * Graph traversal match method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    match(...args: any[]): this;
    /**
     * Graph traversal math method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    math(...args: any[]): this;
    /**
     * Graph traversal max method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    max(...args: any[]): this;
    /**
     * Graph traversal mean method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    mean(...args: any[]): this;
    /**
     * Graph traversal merge method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    merge(...args: any[]): this;
    /**
     * Graph traversal mergeE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    mergeE(...args: any[]): this;
    /**
     * Graph traversal mergeV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    mergeV(...args: any[]): this;
    /**
     * Graph traversal min method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    min(...args: any[]): this;
    /**
     * Graph traversal none method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    none(...args: any[]): this;
    /**
     * Graph traversal not method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    not(...args: any[]): this;
    /**
     * Graph traversal option method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    option(...args: any[]): this;
    /**
     * Graph traversal optional method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    optional(...args: any[]): this;
    /**
     * Graph traversal or method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    or(...args: any[]): this;
    /**
     * Graph traversal order method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    order(...args: any[]): this;
    /**
     * Graph traversal otherV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    otherV(...args: any[]): this;
    /**
     * Graph traversal out method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    out(...args: any[]): this;
    /**
     * Graph traversal outE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    outE(...args: any[]): this;
    /**
     * Graph traversal outV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    outV(...args: any[]): this;
    /**
     * Graph traversal pageRank method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    pageRank(...args: any[]): this;
    /**
     * Graph traversal path method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    path(...args: any[]): this;
    /**
     * Graph traversal peerPressure method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    peerPressure(...args: any[]): this;
    /**
     * Graph traversal product method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    product(...args: any[]): this;
    /**
     * Graph traversal profile method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    profile(...args: any[]): this;
    /**
     * Graph traversal program method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    program(...args: any[]): this;
    /**
     * Graph traversal project method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    project(...args: any[]): this;
    /**
     * Graph traversal properties method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    properties(...args: any[]): this;
    /**
     * Graph traversal property method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    property(...args: any[]): this;
    /**
     * Graph traversal propertyMap method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    propertyMap(...args: any[]): this;
    /**
     * Graph traversal range method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    range(...args: any[]): this;
    /**
     * Graph traversal read method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    read(...args: any[]): this;
    /**
     * Graph traversal repeat method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    repeat(...args: any[]): this;
    /**
     * Graph traversal replace method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    replace(...args: any[]): this;
    /**
     * Graph traversal reverse method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    reverse(...args: any[]): this;
    /**
     * Graph traversal rTrim method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    rTrim(...args: any[]): this;
    /**
     * Graph traversal sack method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    sack(...args: any[]): this;
    /**
     * Graph traversal sample method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    sample(...args: any[]): this;
    /**
     * Graph traversal select method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    select(...args: any[]): this;
    /**
     * Graph traversal shortestPath method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    shortestPath(...args: any[]): this;
    /**
     * Graph traversal sideEffect method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    sideEffect(...args: any[]): this;
    /**
     * Graph traversal simplePath method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    simplePath(...args: any[]): this;
    /**
     * Graph traversal skip method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    skip(...args: any[]): this;
    /**
     * Graph traversal split method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    split(...args: any[]): this;
    /**
     * Graph traversal store method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    store(...args: any[]): this;
    /**
     * Graph traversal subgraph method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    subgraph(...args: any[]): this;
    /**
     * Graph traversal subgraph method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    substring(...args: any[]): this;
    /**
     * Graph traversal sum method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    sum(...args: any[]): this;
    /**
     * Graph traversal tail method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    tail(...args: any[]): this;
    /**
     * Graph traversal timeLimit method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    timeLimit(...args: any[]): this;
    /**
     * Graph traversal times method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    times(...args: any[]): this;
    /**
     * Graph traversal to method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    to(...args: any[]): this;
    /**
     * Graph traversal toE method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    toE(...args: any[]): this;
    /**
     * Graph traversal toLower method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    toLower(...args: any[]): this;
    /**
     * Graph traversal toUpper method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    toUpper(...args: any[]): this;
    /**
     * Graph traversal toV method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    toV(...args: any[]): this;
    /**
     * Graph traversal tree method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    tree(...args: any[]): this;
    /**
     * Graph traversal trim method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    trim(...args: any[]): this;
    /**
     * Graph traversal unfold method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    unfold(...args: any[]): this;
    /**
     * Graph traversal union method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    union(...args: any[]): this;
    /**
     * Graph traversal until method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    until(...args: any[]): this;
    /**
     * Graph traversal value method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    value(...args: any[]): this;
    /**
     * Graph traversal valueMap method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    valueMap(...args: any[]): this;
    /**
     * Graph traversal values method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    values(...args: any[]): this;
    /**
     * Graph traversal where method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    where(...args: any[]): this;
    /**
     * Graph traversal with method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    with_(...args: any[]): this;
    /**
     * Graph traversal write method.
     * @param {...Object} args
     * @returns {GraphTraversal}
     */
    write(...args: any[]): this;
}
export declare class CardinalityValue extends Bytecode {
    /**
     * Creates a new instance of {@link CardinalityValue}.
     * @param {String} card
     * @param {Object} value
     */
    constructor(card: string | EnumValue, value: any);
    /**
     * Create a value with single cardinality.
     * @param {Array} value
     * @returns {CardinalityValue}
     */
    static single(value: any[]): CardinalityValue;
    /**
     * Create a value with list cardinality.
     * @param {Array} value
     * @returns {CardinalityValue}
     */
    static list(value: any[]): CardinalityValue;
    /**
     * Create a value with set cardinality.
     * @param {Array} value
     * @returns {CardinalityValue}
     */
    static set(value: any[]): CardinalityValue;
}
/**
 * Contains the static method definitions
 */
export declare const statics: {
    E: (...args: any[]) => any;
    V: (...args: any[]) => any;
    addE: (...args: any[]) => any;
    addV: (...args: any[]) => any;
    aggregate: (...args: any[]) => any;
    all: (...args: any[]) => any;
    and: (...args: any[]) => any;
    any: (...args: any[]) => any;
    as: (...args: any[]) => any;
    asDate: (...args: any[]) => any;
    asString: (...args: any[]) => any;
    barrier: (...args: any[]) => any;
    both: (...args: any[]) => any;
    bothE: (...args: any[]) => any;
    bothV: (...args: any[]) => any;
    branch: (...args: any[]) => any;
    call: (...args: any[]) => any;
    cap: (...args: any[]) => any;
    choose: (...args: any[]) => any;
    coalesce: (...args: any[]) => any;
    coin: (...args: any[]) => any;
    concat: (...args: any[]) => any;
    constant: (...args: any[]) => any;
    count: (...args: any[]) => any;
    cyclicPath: (...args: any[]) => any;
    dateAdd: (...args: any[]) => any;
    dateDiff: (...args: any[]) => any;
    dedup: (...args: any[]) => any;
    drop: (...args: any[]) => any;
    element: (...args: any[]) => any;
    elementMap: (...args: any[]) => any;
    emit: (...args: any[]) => any;
    fail: (...args: any[]) => any;
    filter: (...args: any[]) => any;
    flatMap: (...args: any[]) => any;
    fold: (...args: any[]) => any;
    format: (...args: any[]) => any;
    group: (...args: any[]) => any;
    groupCount: (...args: any[]) => any;
    has: (...args: any[]) => any;
    hasId: (...args: any[]) => any;
    hasKey: (...args: any[]) => any;
    hasLabel: (...args: any[]) => any;
    hasNot: (...args: any[]) => any;
    hasValue: (...args: any[]) => any;
    id: (...args: any[]) => any;
    identity: (...args: any[]) => any;
    in_: (...args: any[]) => any;
    inE: (...args: any[]) => any;
    inV: (...args: any[]) => any;
    index: (...args: any[]) => any;
    inject: (...args: any[]) => any;
    is: (...args: any[]) => any;
    key: (...args: any[]) => any;
    label: (...args: any[]) => any;
    length: (...args: any[]) => any;
    limit: (...args: any[]) => any;
    local: (...args: any[]) => any;
    loops: (...args: any[]) => any;
    lTrim: (...args: any[]) => any;
    map: (...args: any[]) => any;
    match: (...args: any[]) => any;
    math: (...args: any[]) => any;
    max: (...args: any[]) => any;
    mean: (...args: any[]) => any;
    mergeE: (...args: any[]) => any;
    mergeV: (...args: any[]) => any;
    min: (...args: any[]) => any;
    not: (...args: any[]) => any;
    optional: (...args: any[]) => any;
    or: (...args: any[]) => any;
    order: (...args: any[]) => any;
    otherV: (...args: any[]) => any;
    out: (...args: any[]) => any;
    outE: (...args: any[]) => any;
    outV: (...args: any[]) => any;
    path: (...args: any[]) => any;
    project: (...args: any[]) => any;
    properties: (...args: any[]) => any;
    property: (...args: any[]) => any;
    propertyMap: (...args: any[]) => any;
    range: (...args: any[]) => any;
    repeat: (...args: any[]) => any;
    replace: (...args: any[]) => any;
    reverse: (...args: any[]) => any;
    rTrim: (...args: any[]) => any;
    sack: (...args: any[]) => any;
    sample: (...args: any[]) => any;
    select: (...args: any[]) => any;
    sideEffect: (...args: any[]) => any;
    simplePath: (...args: any[]) => any;
    skip: (...args: any[]) => any;
    split: (...args: any[]) => any;
    store: (...args: any[]) => any;
    subgraph: (...args: any[]) => any;
    substring: (...args: any[]) => any;
    sum: (...args: any[]) => any;
    tail: (...args: any[]) => any;
    timeLimit: (...args: any[]) => any;
    times: (...args: any[]) => any;
    to: (...args: any[]) => any;
    toE: (...args: any[]) => any;
    toLower: (...args: any[]) => any;
    toUpper: (...args: any[]) => any;
    toV: (...args: any[]) => any;
    tree: (...args: any[]) => any;
    trim: (...args: any[]) => any;
    unfold: (...args: any[]) => any;
    union: (...args: any[]) => any;
    until: (...args: any[]) => any;
    value: (...args: any[]) => any;
    valueMap: (...args: any[]) => any;
    values: (...args: any[]) => any;
    where: (...args: any[]) => any;
};
