/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.tinkerpop.gremlin.server.AbstractChannelizer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AllowAllAuthenticator;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpBasicAuthorizationHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.handler.HttpUserAgentHandler;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelizer
extends AbstractChannelizer {
    private static final Logger logger = LoggerFactory.getLogger(HttpChannelizer.class);
    private HttpGremlinEndpointHandler httpGremlinEndpointHandler;

    @Override
    public void init(ServerGremlinExecutor serverGremlinExecutor) {
        super.init(serverGremlinExecutor);
        this.httpGremlinEndpointHandler = new HttpGremlinEndpointHandler(this.serializers, this.gremlinExecutor, this.graphManager, this.settings);
    }

    @Override
    public void configure(ChannelPipeline pipeline) {
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("log-io", LogLevel.DEBUG)});
        }
        pipeline.addLast("http-server", (ChannelHandler)new HttpServerCodec());
        if (logger.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("http-io", LogLevel.DEBUG)});
        }
        HttpObjectAggregator aggregator = new HttpObjectAggregator(this.settings.maxContentLength);
        aggregator.setMaxCumulationBufferComponents(this.settings.maxAccumulationBufferComponents);
        pipeline.addLast("http-aggregator", (ChannelHandler)aggregator);
        if (this.authenticator != null) {
            AbstractAuthenticationHandler authenticationHandler;
            AbstractAuthenticationHandler abstractAuthenticationHandler = authenticationHandler = this.authenticator.getClass() == AllowAllAuthenticator.class ? null : this.instantiateAuthenticationHandler(this.settings);
            if (authenticationHandler != null) {
                pipeline.addLast("authenticator", (ChannelHandler)authenticationHandler);
            }
        }
        if (this.authorizer != null) {
            HttpBasicAuthorizationHandler authorizationHandler = new HttpBasicAuthorizationHandler(this.authorizer);
            pipeline.addLast("authorizer", (ChannelHandler)authorizationHandler);
        }
        pipeline.addLast("http-user-agent-handler", (ChannelHandler)new HttpUserAgentHandler());
        pipeline.addLast("http-gremlin-handler", (ChannelHandler)this.httpGremlinEndpointHandler);
    }

    private AbstractAuthenticationHandler instantiateAuthenticationHandler(Settings settings) {
        String authHandlerClass = settings.authentication.authenticationHandler;
        if (authHandlerClass == null) {
            return new HttpBasicAuthenticationHandler(this.authenticator, settings);
        }
        return this.createAuthenticationHandler(settings);
    }

    @Override
    public void finalize(ChannelPipeline pipeline) {
        pipeline.remove("op-selector");
        pipeline.remove("op-executor");
    }
}

