/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.compress.cost.MemoryCostEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class HybridCostEstimator
extends ACostEstimate {
    private static final long serialVersionUID = -542307595058927576L;
    final ComputationCostEstimator costEstimator;
    final MemoryCostEstimator memoryCostEstimator;

    protected HybridCostEstimator(InstructionTypeCounter counts) {
        this.costEstimator = new ComputationCostEstimator(counts);
        this.memoryCostEstimator = new MemoryCostEstimator();
    }

    protected HybridCostEstimator(int scans, int decompressions, int overlappingDecompressions, int leftMultiplications, int compressedMultiplication, int rightMultiplications, int dictionaryOps, int indexing, boolean isDensifying) {
        this.costEstimator = new ComputationCostEstimator(scans, decompressions, overlappingDecompressions, leftMultiplications, compressedMultiplication, rightMultiplications, dictionaryOps, indexing, isDensifying);
        this.memoryCostEstimator = new MemoryCostEstimator();
    }

    @Override
    protected double getCostSafe(CompressedSizeInfoColGroup g) {
        double cost = this.costEstimator.getCostSafe(g);
        double denseSize = g.getNumRows() * g.getColumns().size() * 8;
        double compressedSize = this.memoryCostEstimator.getCostSafe(g);
        return cost * (compressedSize / denseSize);
    }

    @Override
    public double getCost(MatrixBlock mb) {
        throw new NotImplementedException();
    }

    @Override
    public double getCost(AColGroup cg, int nRows) {
        throw new NotImplementedException();
    }

    @Override
    public boolean shouldSparsify() {
        return false;
    }
}

