/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.sysds.runtime.lineage.LineageEstimator;
import org.apache.sysds.utils.Statistics;

public class LineageEstimatorStatistics {
    private static final LongAdder _ctimeSaved = new LongAdder();
    private static int INSTCOUNT = 10;

    public static void reset() {
        _ctimeSaved.reset();
    }

    public static void incrementSavedComputeTime(long delta) {
        _ctimeSaved.add(delta);
    }

    public static String displayComputeTime() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%.3f", (double)Statistics.getRunTime() * 1.0E-9));
        sb.append("/");
        sb.append(String.format("%.3f", (double)_ctimeSaved.longValue() / 1.0E9));
        return sb.toString();
    }

    public static String displaySize() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%.3f", (double)LineageEstimator._totReusableSize / 1048576.0));
        sb.append("/");
        sb.append(String.format("%.3f", (double)LineageEstimator._totReusedSize / 1048576.0));
        sb.append("/");
        sb.append(String.format("%.3f", (double)LineageEstimator.CACHE_LIMIT / 1048576.0));
        return sb.toString();
    }

    public static String displayReusableInsts() {
        StringBuilder sb = new StringBuilder();
        sb.append("# Instrunction\t  Time(s)  Count \n");
        int instCount = Math.min(INSTCOUNT, LineageEstimator.computeSavingInst.size());
        for (int i = 1; i <= instCount; ++i) {
            MutableTriple<String, Long, Double> op = LineageEstimator.computeSavingInst.poll();
            int tl = String.valueOf((Double)op.getRight() * 0.001).indexOf(".");
            if (!((Double)op.getRight() > 0.0)) continue;
            sb.append(String.valueOf(i) + String.format("%" + (4 - String.valueOf(i).length()) + "s", "") + (String)op.getLeft() + String.format("%" + (15 - ((String)op.getLeft()).length()) + "s", "") + String.format("%.3f", (Double)op.getRight() * 0.001) + String.format("%" + (8 - (tl + 3)) + "s", "") + op.getMiddle() + "\n");
        }
        return sb.toString();
    }

    public static String displayLineageEstimates() {
        StringBuilder sb = new StringBuilder();
        sb.append("Compute Time (Elapsed/Saved): \t" + LineageEstimatorStatistics.displayComputeTime() + " sec.\n");
        sb.append("Space Used (C/R/L): \t\t" + LineageEstimatorStatistics.displaySize() + " MB.\n");
        sb.append("Cache Full Timestamp: \t\t" + LineageEstimator.computeCacheFullTime() + "% instructions.\n");
        sb.append(LineageEstimatorStatistics.displayReusableInsts());
        return sb.toString();
    }
}

