/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class LocatedBlockBuilder {
    protected long flen;
    protected List<LocatedBlock> blocks = Collections.emptyList();
    protected boolean isUC;
    protected LocatedBlock last;
    protected boolean lastComplete;
    protected FileEncryptionInfo feInfo;
    private final int maxBlocks;
    protected ErasureCodingPolicy ecPolicy;

    LocatedBlockBuilder(int maxBlocks) {
        this.maxBlocks = maxBlocks;
    }

    boolean isBlockMax() {
        return this.blocks.size() >= this.maxBlocks;
    }

    LocatedBlockBuilder fileLength(long fileLength) {
        this.flen = fileLength;
        return this;
    }

    LocatedBlockBuilder addBlock(LocatedBlock block) {
        if (this.blocks.isEmpty()) {
            this.blocks = new ArrayList<LocatedBlock>();
        }
        this.blocks.add(block);
        return this;
    }

    LocatedBlock newLocatedBlock(ExtendedBlock eb, DatanodeStorageInfo[] storage, long pos, boolean isCorrupt) {
        LocatedBlock blk = BlockManager.newLocatedBlock(eb, storage, pos, isCorrupt);
        return blk;
    }

    LocatedBlockBuilder lastUC(boolean underConstruction) {
        this.isUC = underConstruction;
        return this;
    }

    LocatedBlockBuilder lastBlock(LocatedBlock block) {
        this.last = block;
        return this;
    }

    LocatedBlockBuilder lastComplete(boolean complete) {
        this.lastComplete = complete;
        return this;
    }

    LocatedBlockBuilder encryption(FileEncryptionInfo fileEncryptionInfo) {
        this.feInfo = fileEncryptionInfo;
        return this;
    }

    LocatedBlockBuilder erasureCoding(ErasureCodingPolicy codingPolicy) {
        this.ecPolicy = codingPolicy;
        return this;
    }

    LocatedBlocks build(DatanodeDescriptor client) {
        return this.build();
    }

    LocatedBlocks build() {
        return new LocatedBlocks(this.flen, this.isUC, this.blocks, this.last, this.lastComplete, this.feInfo, this.ecPolicy);
    }
}

