/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.binder;

import org.apache.commons.digester3.FactoryCreateRule;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.apache.commons.digester3.binder.AbstractBackToLinkedRuleBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryCreateBuilder
extends AbstractBackToLinkedRuleBuilder<FactoryCreateRule> {
    private final ClassLoader classLoader;
    private Class<? extends ObjectCreationFactory<?>> type;
    private String attributeName;
    private boolean ignoreCreateExceptions;
    private ObjectCreationFactory<?> creationFactory;

    FactoryCreateBuilder(String keyPattern, String namespaceURI, RulesBinder mainBinder, LinkedRuleBuilder mainBuilder, ClassLoader classLoader) {
        super(keyPattern, namespaceURI, mainBinder, mainBuilder);
        this.classLoader = classLoader;
    }

    public FactoryCreateBuilder ofType(String className) {
        if (className == null) {
            this.reportError("factoryCreate().ofType( String )", "NULL Java type not allowed");
        }
        try {
            Class<?> type = this.classLoader.loadClass(className);
            if (!ObjectCreationFactory.class.isAssignableFrom(type)) {
                this.reportError("factoryCreate().ofType( String )", "NULL Java type not allowed");
                return this;
            }
            this.type = type;
        }
        catch (ClassNotFoundException e) {
            this.reportError("factoryCreate().ofType( String )", String.format("class '%s' cannot be load", className));
        }
        return this;
    }

    public FactoryCreateBuilder ofType(Class<? extends ObjectCreationFactory<?>> type) {
        if (type == null) {
            this.reportError("factoryCreate().ofType( Class<? extends ObjectCreationFactory<?>> )", "NULL Java type not allowed");
        }
        this.type = type;
        return this;
    }

    public <T> FactoryCreateBuilder usingFactory(ObjectCreationFactory<T> creationFactory) {
        this.creationFactory = creationFactory;
        return this;
    }

    public FactoryCreateBuilder overriddenByAttribute(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public FactoryCreateBuilder ignoreCreateExceptions(boolean ignoreCreateExceptions) {
        this.ignoreCreateExceptions = ignoreCreateExceptions;
        return this;
    }

    @Override
    protected FactoryCreateRule createRule() {
        if (this.type == null && this.attributeName == null && this.creationFactory == null) {
            this.reportError("factoryCreate()", "at least one between 'className', 'attributeName' or 'creationFactory' has to be specified");
        }
        if (this.type != null || this.attributeName != null) {
            return new FactoryCreateRule(this.type, this.attributeName, this.ignoreCreateExceptions);
        }
        return new FactoryCreateRule(this.creationFactory, this.ignoreCreateExceptions);
    }
}

