/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Max;

public class MaxCheck
extends AbstractAnnotationCheck<Max> {
    private static final long serialVersionUID = 1L;
    private boolean inclusive = true;
    private double max;

    @Override
    public void configure(Max constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.value());
        this.setInclusive(constraintAnnotation.inclusive());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Double.toString(this.max));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public double getMax() {
        return this.max;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            double doubleValue = ((Number)valueToValidate).doubleValue();
            if (this.inclusive) {
                return doubleValue <= this.max;
            }
            return doubleValue < this.max;
        }
        String stringValue = valueToValidate.toString();
        try {
            double doubleValue = Double.parseDouble(stringValue);
            if (this.inclusive) {
                return doubleValue <= this.max;
            }
            return doubleValue < this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setInclusive(boolean inclusive) {
        this.inclusive = inclusive;
    }

    public void setMax(double max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }
}

