/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public abstract class AbstractRebaseDiff
implements NodeStateDiff {
    private final NodeBuilder builder;

    protected AbstractRebaseDiff(NodeBuilder builder) {
        this.builder = builder;
    }

    protected abstract AbstractRebaseDiff createDiff(NodeBuilder var1, String var2);

    protected abstract void addExistingProperty(NodeBuilder var1, PropertyState var2, PropertyState var3);

    protected abstract void changeDeletedProperty(NodeBuilder var1, PropertyState var2, PropertyState var3);

    protected abstract void changeChangedProperty(NodeBuilder var1, PropertyState var2, PropertyState var3);

    protected abstract void deleteDeletedProperty(NodeBuilder var1, PropertyState var2);

    protected abstract void deleteChangedProperty(NodeBuilder var1, PropertyState var2);

    protected abstract void addExistingNode(NodeBuilder var1, String var2, NodeState var3, NodeState var4);

    protected abstract void changeDeletedNode(NodeBuilder var1, String var2, NodeState var3, NodeState var4);

    protected abstract void deleteDeletedNode(NodeBuilder var1, String var2, NodeState var3);

    protected abstract void deleteChangedNode(NodeBuilder var1, String var2, NodeState var3);

    @Override
    public boolean propertyAdded(PropertyState after) {
        PropertyState other = this.builder.getProperty(after.getName());
        if (other == null) {
            this.builder.setProperty(after);
        } else if (!other.equals(after)) {
            this.addExistingProperty(this.builder, other, after);
        }
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        PropertyState other = this.builder.getProperty(before.getName());
        if (other == null) {
            this.changeDeletedProperty(this.builder, after, before);
        } else if (other.equals(before)) {
            this.builder.setProperty(after);
        } else if (!other.equals(after)) {
            this.changeChangedProperty(this.builder, before, after);
        }
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        PropertyState other = this.builder.getProperty(before.getName());
        if (other == null) {
            this.deleteDeletedProperty(this.builder, before);
        } else if (other.equals(before)) {
            this.builder.removeProperty(before.getName());
        } else {
            this.deleteChangedProperty(this.builder, before);
        }
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        if (this.builder.hasChildNode(name)) {
            after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, this.createDiff(this.builder, name));
        } else {
            this.builder.setChildNode(name, after);
        }
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (this.builder.hasChildNode(name)) {
            after.compareAgainstBaseState(before, this.createDiff(this.builder, name));
        } else {
            if (after.equals(before)) {
                return false;
            }
            this.changeDeletedNode(this.builder, name, after, before);
        }
        return true;
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        if (!this.builder.hasChildNode(name)) {
            this.deleteDeletedNode(this.builder, name, before);
        } else if (before.equals(this.builder.child(name).getNodeState())) {
            this.builder.getChildNode(name).remove();
        } else {
            this.deleteChangedNode(this.builder, name, before);
        }
        return true;
    }
}

