/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.List;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.MissingSourceDimensionsException;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SubOperationInfo {
    private static final Class<?>[][] COMPATIBLE_TYPES = new Class[][]{{GeodeticCRS.class}, {VerticalCRS.class, GeodeticCRS.class}, {TemporalCRS.class}, {DefaultParametricCRS.class}, {EngineeringCRS.class}, {ImageCRS.class}};
    final CoordinateOperation operation;
    private double[] constantCoordinates;
    private final int sourceLowerDimension;
    private final int sourceUpperDimension;
    private final int targetLowerDimension;
    private final int targetUpperDimension;
    final int targetComponentIndex;
    final SingleCRS targetComponent;

    private static Class<?> type(SingleCRS crs) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = (SingleCRS)((GeneralDerivedCRS)crs).getBaseCRS();
        }
        return crs.getClass();
    }

    private SubOperationInfo(CoordinateOperation operation, int sourceLowerDimension, int sourceUpperDimension, int targetLowerDimension, int targetUpperDimension, int targetComponentIndex, SingleCRS targetComponent) {
        this.operation = operation;
        this.sourceLowerDimension = sourceLowerDimension;
        this.sourceUpperDimension = sourceUpperDimension;
        this.targetLowerDimension = targetLowerDimension;
        this.targetUpperDimension = targetUpperDimension;
        this.targetComponentIndex = targetComponentIndex;
        this.targetComponent = targetComponent;
    }

    static SubOperationInfo[] createSteps(CoordinateOperationFinder caller, CoordinateReferenceSystem sourceCRS, List<? extends SingleCRS> sources, List<? extends SingleCRS> targets) throws FactoryException, TransformException {
        SubOperationInfo[] infos = new SubOperationInfo[targets.size()];
        boolean[] sourceComponentIsUsed = new boolean[sources.size()];
        int targetUpperDimension = 0;
        int targetComponentIndex = 0;
        while (targetComponentIndex < infos.length) {
            SingleCRS targetComponent = targets.get(targetComponentIndex);
            int targetLowerDimension = targetUpperDimension;
            targetUpperDimension += targetComponent.getCoordinateSystem().getDimension();
            Class<?> targetType = SubOperationInfo.type(targetComponent);
            OperationNotFoundException failure = null;
            CoordinateOperation operation = null;
            int sourceLowerDimension = 0;
            int sourceUpperDimension = 0;
            block3: for (int sourceComponentIndex = 0; sourceComponentIndex < sourceComponentIsUsed.length; ++sourceComponentIndex) {
                SingleCRS sourceComponent = sources.get(sourceComponentIndex);
                sourceUpperDimension += sourceComponent.getCoordinateSystem().getDimension();
                if (!sourceComponentIsUsed[sourceComponentIndex]) {
                    Class<?> sourceType = SubOperationInfo.type(sourceComponent);
                    for (Class<?>[] compatibleTypes : COMPATIBLE_TYPES) {
                        if (!compatibleTypes[0].isAssignableFrom(targetType)) continue;
                        for (Class<?> compatibleType : compatibleTypes) {
                            if (!compatibleType.isAssignableFrom(sourceType)) continue;
                            try {
                                operation = caller.createOperation((CoordinateReferenceSystem)sourceComponent, (CoordinateReferenceSystem)targetComponent);
                                sourceComponentIsUsed[sourceComponentIndex] = true;
                                break block3;
                            }
                            catch (OperationNotFoundException exception) {
                                if (failure == null) {
                                    failure = exception;
                                    continue;
                                }
                                failure.addSuppressed((Throwable)exception);
                            }
                        }
                    }
                }
                sourceLowerDimension = sourceUpperDimension;
            }
            if (failure != null) {
                if (operation == null) {
                    throw failure;
                }
                caller.recoverableException("createOperationStep", (Exception)((Object)failure));
            }
            SubOperationInfo info = new SubOperationInfo(operation, sourceLowerDimension, sourceUpperDimension, targetLowerDimension, targetUpperDimension, targetComponentIndex, targetComponent);
            if (operation == null) {
                CoordinateSystemAxis missing = info.fetchConstantsForMissingSourceDimensions(caller.context);
                if (info.constantCoordinates == null) {
                    MissingSourceDimensionsException e;
                    if (missing != null) {
                        e = new MissingSourceDimensionsException(caller.resources().getString((short)109, caller.label((IdentifiedObject)missing)));
                        e.addMissing(missing.getDirection());
                    } else {
                        e = new MissingSourceDimensionsException(caller.notFoundMessage(sourceCRS, (CoordinateReferenceSystem)targetComponent));
                        e.addMissing(sourceCRS.getCoordinateSystem(), targetComponent.getCoordinateSystem());
                    }
                    throw e;
                }
            }
            infos[targetComponentIndex++] = info;
        }
        return infos;
    }

    private CoordinateSystemAxis fetchConstantsForMissingSourceDimensions(CoordinateOperationContext context) {
        DirectPosition coordinates;
        if (context != null && (coordinates = context.getConstantCoordinates()) != null) {
            int indexOfConstant = this.targetLowerDimension;
            CoordinateReferenceSystem crs = coordinates.getCoordinateReferenceSystem();
            if (crs != null && (indexOfConstant = CRS.locateDimensions(crs, this.targetComponent).nextSetBit(0)) < 0) {
                return null;
            }
            int d = coordinates.getDimension();
            double[] c = new double[this.targetUpperDimension - this.targetLowerDimension];
            for (int i = 0; i < c.length; ++i) {
                if (indexOfConstant < d && !Double.isNaN(c[i] = coordinates.getOrdinate(indexOfConstant++))) continue;
                return this.targetComponent.getCoordinateSystem().getAxis(i);
            }
            this.constantCoordinates = c;
        }
        return null;
    }

    static CoordinateReferenceSystem[] getSourceCRS(SubOperationInfo[] selected) {
        int n = selected.length;
        int last = n - 1;
        for (int i = 0; i < n; ++i) {
            SubOperationInfo component = selected[i];
            if (component.operation != null) continue;
            System.arraycopy(selected, i + 1, selected, i, last - i);
            selected[last] = component;
            --n;
            --i;
        }
        CoordinateReferenceSystem[] stepComponents = new CoordinateReferenceSystem[n];
        for (int i = 0; i < n; ++i) {
            stepComponents[i] = selected[i].operation.getSourceCRS();
        }
        return stepComponents;
    }

    static int indexOfFinal(SubOperationInfo[] selected) {
        int n = selected.length;
        while (n != 0 && selected[--n].isIdentity()) {
        }
        return n;
    }

    static MatrixSIS sourceToSelected(int sourceDimensions, SubOperationInfo[] selected) {
        int selectedDimensions = 0;
        for (SubOperationInfo component : selected) {
            if (component.operation == null) break;
            selectedDimensions += component.sourceUpperDimension - component.sourceLowerDimension;
        }
        MatrixSIS select = Matrices.createZero(selectedDimensions + 1, sourceDimensions + 1);
        select.setElement(selectedDimensions, sourceDimensions, 1.0);
        int j = 0;
        for (SubOperationInfo component : selected) {
            if (component.operation == null) break;
            for (int i = component.sourceLowerDimension; i < component.sourceUpperDimension; ++i) {
                select.setElement(j++, i, 1.0);
            }
        }
        return select;
    }

    final boolean isIdentity() {
        return this.operation != null && this.operation.getMathTransform().isIdentity();
    }

    static MatrixSIS createConstantOperation(CoordinateOperationContext context, SubOperationInfo[] selected, int srcDim, int tgtDim) throws MissingSourceDimensionsException {
        MatrixSIS matrix = Matrices.createZero(tgtDim + 1, srcDim + 1);
        matrix.setElement(tgtDim, srcDim, 1.0);
        for (SubOperationInfo component : selected) {
            component.setConstantTerms(context, matrix, srcDim);
        }
        return matrix;
    }

    private void setConstantTerms(CoordinateOperationContext context, MatrixSIS matrix, int translationColumn) {
        if (this.constantCoordinates != null) {
            int j = this.targetUpperDimension - this.targetLowerDimension;
            while (--j >= 0) {
                matrix.setElement(this.targetLowerDimension + j, translationColumn, this.constantCoordinates[j]);
            }
        } else {
            boolean[] targetDimensionIsUsed = new boolean[this.targetUpperDimension - this.targetLowerDimension];
            Matrix last = MathTransforms.getMatrix(MathTransforms.getLastStep(this.operation.getMathTransform()));
            if (last != null) {
                this.fetchConstantsForMissingSourceDimensions(context);
                if (this.constantCoordinates != null) {
                    int j = last.getNumRow() - 1;
                    block1: while (--j >= 0) {
                        int i = last.getNumCol();
                        while (--i >= 0) {
                            if (last.getElement(j, i) == 0.0) continue;
                            continue block1;
                        }
                        matrix.setElement(this.targetLowerDimension + j, translationColumn, this.constantCoordinates[j]);
                        targetDimensionIsUsed[j] = true;
                    }
                }
            }
            int i = this.sourceLowerDimension;
            for (int j = 0; j < targetDimensionIsUsed.length; ++j) {
                if (targetDimensionIsUsed[j]) continue;
                matrix.setElement(this.targetLowerDimension + j, i++, 1.0);
            }
        }
    }

    final boolean canStoreInCache() {
        return this.constantCoordinates == null;
    }
}

