/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.Wraparound;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformJoiner;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public class WraparoundTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1959034793759509170L;
    private final int dimension;
    public final int wraparoundDimension;
    public final double period;
    public final double sourceMedian;
    private volatile transient MathTransform inverse;

    protected WraparoundTransform(int dimension, int wraparoundDimension, double period, double sourceMedian) {
        this.dimension = dimension;
        this.wraparoundDimension = wraparoundDimension;
        this.period = period;
        this.sourceMedian = sourceMedian;
    }

    protected WraparoundTransform(WraparoundTransform other) {
        this.dimension = other.dimension;
        this.wraparoundDimension = other.wraparoundDimension;
        this.period = other.period;
        this.sourceMedian = other.sourceMedian;
        this.inverse = other.inverse;
    }

    private WraparoundTransform redimension(boolean linearFirst, Matrix middle) {
        int n = (linearFirst ? middle.getNumRow() : middle.getNumCol()) - 1;
        if (n == this.dimension) {
            return this;
        }
        if (n < this.wraparoundDimension && this.getClass() == WraparoundTransform.class) {
            return new WraparoundTransform(n, this.wraparoundDimension, this.period, this.sourceMedian);
        }
        return null;
    }

    public static MathTransform create(int dimension, int wraparoundDimension, double period, double sourceMedian, double targetMedian) {
        ArgumentChecks.ensureStrictlyPositive((String)"dimension", (int)dimension);
        ArgumentChecks.ensureBetween((String)"wraparoundDimension", (int)0, (int)(dimension - 1), (int)wraparoundDimension);
        ArgumentChecks.ensureStrictlyPositive((String)"period", (double)period);
        ArgumentChecks.ensureFinite((String)"targetMedian", (double)targetMedian);
        WraparoundTransform tr = new WraparoundTransform(dimension, wraparoundDimension, period, sourceMedian - targetMedian);
        if (targetMedian == 0.0) {
            return tr;
        }
        try {
            double[] vector = new double[dimension];
            vector[wraparoundDimension] = targetMedian;
            LinearTransform denormalize = MathTransforms.translation(vector);
            MathTransform ct = MathTransforms.concatenate(denormalize.inverse(), tr, denormalize);
            if (sourceMedian == 0.0) {
                tr.inverse = tr;
            }
            return ct;
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MathTransform replace(MathTransform transform, Function<? super WraparoundTransform, ? extends WraparoundTransform> replacement) {
        ArgumentChecks.ensureNonNull((String)"transform", (Object)transform);
        ArgumentChecks.ensureNonNull((String)"replacement", replacement);
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)transform;
            MathTransform tr1 = WraparoundTransform.replace(ct.transform1, replacement);
            MathTransform tr2 = WraparoundTransform.replace(ct.transform2, replacement);
            if (tr1 != ct.transform1 || tr2 != ct.transform2) {
                transform = MathTransforms.concatenate(tr1, tr2);
            }
        } else if (transform instanceof WraparoundTransform) {
            transform = Objects.requireNonNull(replacement.apply((WraparoundTransform)transform));
        }
        return transform;
    }

    @Override
    public final int getSourceDimensions() {
        return this.dimension;
    }

    @Override
    public final int getTargetDimensions() {
        return this.dimension;
    }

    protected double shift(double x) {
        return Math.IEEEremainder(x, this.period);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.dimension);
            dstPts[dstOff += this.wraparoundDimension] = this.shift(dstPts[dstOff]);
        }
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
        dstOff += this.wraparoundDimension;
        while (--numPts >= 0) {
            dstPts[dstOff] = this.shift(dstPts[dstOff]);
            dstOff += this.dimension;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * this.dimension);
        dstOff += this.wraparoundDimension;
        while (--numPts >= 0) {
            dstPts[dstOff] = (float)this.shift(dstPts[dstOff]);
            dstOff += this.dimension;
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return Matrices.createIdentity(this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        MathTransform tr = this.inverse;
        if (tr == null) {
            if (!Double.isFinite(this.sourceMedian)) {
                return super.inverse();
            }
            if (this.sourceMedian == 0.0) {
                this.inverse = tr = this;
            } else {
                WraparoundTransform wraparoundTransform = this;
                synchronized (wraparoundTransform) {
                    tr = this.inverse;
                    if (tr == null) {
                        tr = WraparoundTransform.create(this.dimension, this.wraparoundDimension, this.period, 0.0, this.sourceMedian);
                        ConcatenatedTransform.setInverse(tr, this);
                        this.inverse = tr;
                    }
                }
            }
        }
        return tr;
    }

    @Override
    protected void tryConcatenate(TransformJoiner context) throws FactoryException {
        int relativeIndex = 1;
        do {
            WraparoundTransform concatenated;
            WraparoundTransform merged;
            boolean linearFirst;
            int firstOrLast;
            MathTransform tr;
            Matrix middle;
            MathTransform neighbor;
            if ((neighbor = (MathTransform)context.getTransform(relativeIndex).orElse(null)) instanceof WraparoundTransform) {
                WraparoundTransform merged2;
                WraparoundTransform other = (WraparoundTransform)neighbor;
                WraparoundTransform wraparoundTransform = merged2 = relativeIndex < 0 ? other.merge(this) : this.merge(other);
                if (merged2 != null && context.replace(relativeIndex, merged2)) {
                    return;
                }
            }
            if ((middle = MathTransforms.getMatrix(neighbor)) == null || !((tr = (MathTransform)context.getTransform(firstOrLast = relativeIndex * 2).orElse(null)) instanceof WraparoundTransform)) continue;
            WraparoundTransform other = (WraparoundTransform)tr;
            if (this.canMove(middle)) {
                linearFirst = relativeIndex >= 0;
            } else {
                if (!other.canMove(middle)) continue;
                linearFirst = relativeIndex < 0;
            }
            WraparoundTransform wraparoundTransform = merged = relativeIndex < 0 ? other.merge(this) : this.merge(other);
            if (merged != null) {
                merged = merged.redimension(linearFirst, middle);
            }
            if ((concatenated = merged) == null) {
                concatenated = relativeIndex >= 0 ? context.concatenate(this, other) : context.concatenate(other, this);
            }
            MathTransform mathTransform = concatenated = linearFirst ? context.concatenate(neighbor, concatenated) : context.concatenate(concatenated, neighbor);
            if (!context.replace(firstOrLast, concatenated)) continue;
            return;
        } while ((relativeIndex = -relativeIndex) < 0);
        HashMap<Integer, Integer> dimensions = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.dimension; ++i) {
            if (i == this.wraparoundDimension) continue;
            dimensions.put(i, i);
        }
        if (!context.replacePassThrough(dimensions)) {
            super.tryConcatenate(context);
        }
    }

    private boolean canMove(Matrix middle) {
        double v;
        int i = middle.getNumCol();
        int j = middle.getNumRow();
        if (this.wraparoundDimension < i) {
            while (--j >= 0) {
                v = middle.getElement(j, this.wraparoundDimension);
                if (v == (double)(j == this.wraparoundDimension ? 1 : 0)) continue;
                return false;
            }
            j = middle.getNumRow();
        }
        if (this.wraparoundDimension < j) {
            while (--i >= 0) {
                v = middle.getElement(this.wraparoundDimension, i);
                if (v == (double)(i == this.wraparoundDimension ? 1 : 0)) continue;
                return false;
            }
        }
        return true;
    }

    private WraparoundTransform merge(WraparoundTransform other) {
        if (other.wraparoundDimension == this.wraparoundDimension && Numerics.equals((double)this.period, (double)other.period)) {
            return this;
        }
        return null;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Wraparound.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameters pg = Parameters.castOrWrap(this.getParameterDescriptors().createValue());
        pg.getOrCreate(Wraparound.DIMENSION).setValue(this.dimension);
        pg.getOrCreate(Wraparound.WRAPAROUND_DIMENSION).setValue(this.wraparoundDimension);
        pg.getOrCreate(Wraparound.PERIOD).setValue(this.period);
        return pg;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            WraparoundTransform other = (WraparoundTransform)object;
            return other.dimension == this.dimension && other.wraparoundDimension == this.wraparoundDimension && Numerics.equals((double)this.period, (double)other.period) && Numerics.equals((double)this.sourceMedian, (double)other.sourceMedian);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return this.dimension * 31 + this.wraparoundDimension + Double.hashCode(this.period) + 7 * Double.hashCode(this.sourceMedian);
    }
}

