/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetUnconfirmedServiceRequestUnconfirmedEventNotification is the corresponding interface of BACnetUnconfirmedServiceRequestUnconfirmedEventNotification
type BACnetUnconfirmedServiceRequestUnconfirmedEventNotification interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetUnconfirmedServiceRequest
	// GetProcessIdentifier returns ProcessIdentifier (property field)
	GetProcessIdentifier() BACnetContextTagUnsignedInteger
	// GetInitiatingDeviceIdentifier returns InitiatingDeviceIdentifier (property field)
	GetInitiatingDeviceIdentifier() BACnetContextTagObjectIdentifier
	// GetEventObjectIdentifier returns EventObjectIdentifier (property field)
	GetEventObjectIdentifier() BACnetContextTagObjectIdentifier
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() BACnetTimeStampEnclosed
	// GetNotificationClass returns NotificationClass (property field)
	GetNotificationClass() BACnetContextTagUnsignedInteger
	// GetPriority returns Priority (property field)
	GetPriority() BACnetContextTagUnsignedInteger
	// GetEventType returns EventType (property field)
	GetEventType() BACnetEventTypeTagged
	// GetMessageText returns MessageText (property field)
	GetMessageText() BACnetContextTagCharacterString
	// GetNotifyType returns NotifyType (property field)
	GetNotifyType() BACnetNotifyTypeTagged
	// GetAckRequired returns AckRequired (property field)
	GetAckRequired() BACnetContextTagBoolean
	// GetFromState returns FromState (property field)
	GetFromState() BACnetEventStateTagged
	// GetToState returns ToState (property field)
	GetToState() BACnetEventStateTagged
	// GetEventValues returns EventValues (property field)
	GetEventValues() BACnetNotificationParameters
	// IsBACnetUnconfirmedServiceRequestUnconfirmedEventNotification is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetUnconfirmedServiceRequestUnconfirmedEventNotification()
	// CreateBuilder creates a BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	CreateBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder() BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
}

// _BACnetUnconfirmedServiceRequestUnconfirmedEventNotification is the data-structure of this message
type _BACnetUnconfirmedServiceRequestUnconfirmedEventNotification struct {
	BACnetUnconfirmedServiceRequestContract
	ProcessIdentifier          BACnetContextTagUnsignedInteger
	InitiatingDeviceIdentifier BACnetContextTagObjectIdentifier
	EventObjectIdentifier      BACnetContextTagObjectIdentifier
	Timestamp                  BACnetTimeStampEnclosed
	NotificationClass          BACnetContextTagUnsignedInteger
	Priority                   BACnetContextTagUnsignedInteger
	EventType                  BACnetEventTypeTagged
	MessageText                BACnetContextTagCharacterString
	NotifyType                 BACnetNotifyTypeTagged
	AckRequired                BACnetContextTagBoolean
	FromState                  BACnetEventStateTagged
	ToState                    BACnetEventStateTagged
	EventValues                BACnetNotificationParameters
}

var _ BACnetUnconfirmedServiceRequestUnconfirmedEventNotification = (*_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification)(nil)
var _ BACnetUnconfirmedServiceRequestRequirements = (*_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification)(nil)

// NewBACnetUnconfirmedServiceRequestUnconfirmedEventNotification factory function for _BACnetUnconfirmedServiceRequestUnconfirmedEventNotification
func NewBACnetUnconfirmedServiceRequestUnconfirmedEventNotification(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, messageText BACnetContextTagCharacterString, notifyType BACnetNotifyTypeTagged, ackRequired BACnetContextTagBoolean, fromState BACnetEventStateTagged, toState BACnetEventStateTagged, eventValues BACnetNotificationParameters, serviceRequestLength uint16) *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification {
	if processIdentifier == nil {
		panic("processIdentifier of type BACnetContextTagUnsignedInteger for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if initiatingDeviceIdentifier == nil {
		panic("initiatingDeviceIdentifier of type BACnetContextTagObjectIdentifier for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if eventObjectIdentifier == nil {
		panic("eventObjectIdentifier of type BACnetContextTagObjectIdentifier for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if timestamp == nil {
		panic("timestamp of type BACnetTimeStampEnclosed for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if notificationClass == nil {
		panic("notificationClass of type BACnetContextTagUnsignedInteger for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if priority == nil {
		panic("priority of type BACnetContextTagUnsignedInteger for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if eventType == nil {
		panic("eventType of type BACnetEventTypeTagged for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if notifyType == nil {
		panic("notifyType of type BACnetNotifyTypeTagged for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	if toState == nil {
		panic("toState of type BACnetEventStateTagged for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification must not be nil")
	}
	_result := &_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification{
		BACnetUnconfirmedServiceRequestContract: NewBACnetUnconfirmedServiceRequest(serviceRequestLength),
		ProcessIdentifier:                       processIdentifier,
		InitiatingDeviceIdentifier:              initiatingDeviceIdentifier,
		EventObjectIdentifier:                   eventObjectIdentifier,
		Timestamp:                               timestamp,
		NotificationClass:                       notificationClass,
		Priority:                                priority,
		EventType:                               eventType,
		MessageText:                             messageText,
		NotifyType:                              notifyType,
		AckRequired:                             ackRequired,
		FromState:                               fromState,
		ToState:                                 toState,
		EventValues:                             eventValues,
	}
	_result.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder is a builder for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification
type BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, notifyType BACnetNotifyTypeTagged, toState BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithProcessIdentifier adds ProcessIdentifier (property field)
	WithProcessIdentifier(BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithProcessIdentifierBuilder adds ProcessIdentifier (property field) which is build by the builder
	WithProcessIdentifierBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithInitiatingDeviceIdentifier adds InitiatingDeviceIdentifier (property field)
	WithInitiatingDeviceIdentifier(BACnetContextTagObjectIdentifier) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithInitiatingDeviceIdentifierBuilder adds InitiatingDeviceIdentifier (property field) which is build by the builder
	WithInitiatingDeviceIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithEventObjectIdentifier adds EventObjectIdentifier (property field)
	WithEventObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithEventObjectIdentifierBuilder adds EventObjectIdentifier (property field) which is build by the builder
	WithEventObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(BACnetTimeStampEnclosed) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithTimestampBuilder adds Timestamp (property field) which is build by the builder
	WithTimestampBuilder(func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithNotificationClass adds NotificationClass (property field)
	WithNotificationClass(BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithNotificationClassBuilder adds NotificationClass (property field) which is build by the builder
	WithNotificationClassBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithPriority adds Priority (property field)
	WithPriority(BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithPriorityBuilder adds Priority (property field) which is build by the builder
	WithPriorityBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithEventType adds EventType (property field)
	WithEventType(BACnetEventTypeTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithEventTypeBuilder adds EventType (property field) which is build by the builder
	WithEventTypeBuilder(func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithMessageText adds MessageText (property field)
	WithOptionalMessageText(BACnetContextTagCharacterString) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithOptionalMessageTextBuilder adds MessageText (property field) which is build by the builder
	WithOptionalMessageTextBuilder(func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithNotifyType adds NotifyType (property field)
	WithNotifyType(BACnetNotifyTypeTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithNotifyTypeBuilder adds NotifyType (property field) which is build by the builder
	WithNotifyTypeBuilder(func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithAckRequired adds AckRequired (property field)
	WithOptionalAckRequired(BACnetContextTagBoolean) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithOptionalAckRequiredBuilder adds AckRequired (property field) which is build by the builder
	WithOptionalAckRequiredBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithFromState adds FromState (property field)
	WithOptionalFromState(BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithOptionalFromStateBuilder adds FromState (property field) which is build by the builder
	WithOptionalFromStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithToState adds ToState (property field)
	WithToState(BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithToStateBuilder adds ToState (property field) which is build by the builder
	WithToStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithEventValues adds EventValues (property field)
	WithOptionalEventValues(BACnetNotificationParameters) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// WithOptionalEventValuesBuilder adds EventValues (property field) which is build by the builder
	WithOptionalEventValuesBuilder(func(BACnetNotificationParametersBuilder) BACnetNotificationParametersBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetUnconfirmedServiceRequestBuilder
	// Build builds the BACnetUnconfirmedServiceRequestUnconfirmedEventNotification or returns an error if something is wrong
	Build() (BACnetUnconfirmedServiceRequestUnconfirmedEventNotification, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetUnconfirmedServiceRequestUnconfirmedEventNotification
}

// NewBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder() creates a BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
func NewBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder() BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	return &_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder{_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification: new(_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification)}
}

type _BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder struct {
	*_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification

	parentBuilder *_BACnetUnconfirmedServiceRequestBuilder

	collectedErr []error
}

var _ (BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) = (*_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder)(nil)

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) setParent(contract BACnetUnconfirmedServiceRequestContract) {
	b.BACnetUnconfirmedServiceRequestContract = contract
	contract.(*_BACnetUnconfirmedServiceRequest)._SubType = b._BACnetUnconfirmedServiceRequestUnconfirmedEventNotification
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithMandatoryFields(processIdentifier BACnetContextTagUnsignedInteger, initiatingDeviceIdentifier BACnetContextTagObjectIdentifier, eventObjectIdentifier BACnetContextTagObjectIdentifier, timestamp BACnetTimeStampEnclosed, notificationClass BACnetContextTagUnsignedInteger, priority BACnetContextTagUnsignedInteger, eventType BACnetEventTypeTagged, notifyType BACnetNotifyTypeTagged, toState BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	return b.WithProcessIdentifier(processIdentifier).WithInitiatingDeviceIdentifier(initiatingDeviceIdentifier).WithEventObjectIdentifier(eventObjectIdentifier).WithTimestamp(timestamp).WithNotificationClass(notificationClass).WithPriority(priority).WithEventType(eventType).WithNotifyType(notifyType).WithToState(toState)
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithProcessIdentifier(processIdentifier BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.ProcessIdentifier = processIdentifier
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithProcessIdentifierBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.ProcessIdentifier.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.ProcessIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithInitiatingDeviceIdentifier(initiatingDeviceIdentifier BACnetContextTagObjectIdentifier) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.InitiatingDeviceIdentifier = initiatingDeviceIdentifier
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithInitiatingDeviceIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.InitiatingDeviceIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.InitiatingDeviceIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithEventObjectIdentifier(eventObjectIdentifier BACnetContextTagObjectIdentifier) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.EventObjectIdentifier = eventObjectIdentifier
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithEventObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.EventObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.EventObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithTimestamp(timestamp BACnetTimeStampEnclosed) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithTimestampBuilder(builderSupplier func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.Timestamp.CreateBACnetTimeStampEnclosedBuilder())
	var err error
	b.Timestamp, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTimeStampEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithNotificationClass(notificationClass BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.NotificationClass = notificationClass
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithNotificationClassBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.NotificationClass.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.NotificationClass, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithPriority(priority BACnetContextTagUnsignedInteger) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.Priority = priority
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithPriorityBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.Priority.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.Priority, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithEventType(eventType BACnetEventTypeTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.EventType = eventType
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithEventTypeBuilder(builderSupplier func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.EventType.CreateBACnetEventTypeTaggedBuilder())
	var err error
	b.EventType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalMessageText(messageText BACnetContextTagCharacterString) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.MessageText = messageText
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalMessageTextBuilder(builderSupplier func(BACnetContextTagCharacterStringBuilder) BACnetContextTagCharacterStringBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.MessageText.CreateBACnetContextTagCharacterStringBuilder())
	var err error
	b.MessageText, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithNotifyType(notifyType BACnetNotifyTypeTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.NotifyType = notifyType
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithNotifyTypeBuilder(builderSupplier func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.NotifyType.CreateBACnetNotifyTypeTaggedBuilder())
	var err error
	b.NotifyType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetNotifyTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalAckRequired(ackRequired BACnetContextTagBoolean) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.AckRequired = ackRequired
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalAckRequiredBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.AckRequired.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.AckRequired, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalFromState(fromState BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.FromState = fromState
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalFromStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.FromState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.FromState, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithToState(toState BACnetEventStateTagged) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.ToState = toState
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithToStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.ToState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.ToState, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalEventValues(eventValues BACnetNotificationParameters) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	b.EventValues = eventValues
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) WithOptionalEventValuesBuilder(builderSupplier func(BACnetNotificationParametersBuilder) BACnetNotificationParametersBuilder) BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	builder := builderSupplier(b.EventValues.CreateBACnetNotificationParametersBuilder())
	var err error
	b.EventValues, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetNotificationParametersBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) Build() (BACnetUnconfirmedServiceRequestUnconfirmedEventNotification, error) {
	if b.ProcessIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'processIdentifier' not set"))
	}
	if b.InitiatingDeviceIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'initiatingDeviceIdentifier' not set"))
	}
	if b.EventObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventObjectIdentifier' not set"))
	}
	if b.Timestamp == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'timestamp' not set"))
	}
	if b.NotificationClass == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'notificationClass' not set"))
	}
	if b.Priority == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'priority' not set"))
	}
	if b.EventType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'eventType' not set"))
	}
	if b.NotifyType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'notifyType' not set"))
	}
	if b.ToState == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'toState' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetUnconfirmedServiceRequestUnconfirmedEventNotification.deepCopy(), nil
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) MustBuild() BACnetUnconfirmedServiceRequestUnconfirmedEventNotification {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) Done() BACnetUnconfirmedServiceRequestBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetUnconfirmedServiceRequestBuilder().(*_BACnetUnconfirmedServiceRequestBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) buildForBACnetUnconfirmedServiceRequest() (BACnetUnconfirmedServiceRequest, error) {
	return b.Build()
}

func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder().(*_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder creates a BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder
func (b *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) CreateBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder() BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder {
	if b == nil {
		return NewBACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder()
	}
	return &_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationBuilder{_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetServiceChoice() BACnetUnconfirmedServiceChoice {
	return BACnetUnconfirmedServiceChoice_UNCONFIRMED_EVENT_NOTIFICATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetParent() BACnetUnconfirmedServiceRequestContract {
	return m.BACnetUnconfirmedServiceRequestContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetProcessIdentifier() BACnetContextTagUnsignedInteger {
	return m.ProcessIdentifier
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetInitiatingDeviceIdentifier() BACnetContextTagObjectIdentifier {
	return m.InitiatingDeviceIdentifier
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetEventObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.EventObjectIdentifier
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetTimestamp() BACnetTimeStampEnclosed {
	return m.Timestamp
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetNotificationClass() BACnetContextTagUnsignedInteger {
	return m.NotificationClass
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetPriority() BACnetContextTagUnsignedInteger {
	return m.Priority
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetEventType() BACnetEventTypeTagged {
	return m.EventType
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetMessageText() BACnetContextTagCharacterString {
	return m.MessageText
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetNotifyType() BACnetNotifyTypeTagged {
	return m.NotifyType
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetAckRequired() BACnetContextTagBoolean {
	return m.AckRequired
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetFromState() BACnetEventStateTagged {
	return m.FromState
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetToState() BACnetEventStateTagged {
	return m.ToState
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetEventValues() BACnetNotificationParameters {
	return m.EventValues
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetUnconfirmedServiceRequestUnconfirmedEventNotification(structType any) BACnetUnconfirmedServiceRequestUnconfirmedEventNotification {
	if casted, ok := structType.(BACnetUnconfirmedServiceRequestUnconfirmedEventNotification); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetUnconfirmedServiceRequestUnconfirmedEventNotification); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetTypeName() string {
	return "BACnetUnconfirmedServiceRequestUnconfirmedEventNotification"
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).getLengthInBits(ctx))

	// Simple field (processIdentifier)
	lengthInBits += m.ProcessIdentifier.GetLengthInBits(ctx)

	// Simple field (initiatingDeviceIdentifier)
	lengthInBits += m.InitiatingDeviceIdentifier.GetLengthInBits(ctx)

	// Simple field (eventObjectIdentifier)
	lengthInBits += m.EventObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += m.Timestamp.GetLengthInBits(ctx)

	// Simple field (notificationClass)
	lengthInBits += m.NotificationClass.GetLengthInBits(ctx)

	// Simple field (priority)
	lengthInBits += m.Priority.GetLengthInBits(ctx)

	// Simple field (eventType)
	lengthInBits += m.EventType.GetLengthInBits(ctx)

	// Optional Field (messageText)
	if m.MessageText != nil {
		lengthInBits += m.MessageText.GetLengthInBits(ctx)
	}

	// Simple field (notifyType)
	lengthInBits += m.NotifyType.GetLengthInBits(ctx)

	// Optional Field (ackRequired)
	if m.AckRequired != nil {
		lengthInBits += m.AckRequired.GetLengthInBits(ctx)
	}

	// Optional Field (fromState)
	if m.FromState != nil {
		lengthInBits += m.FromState.GetLengthInBits(ctx)
	}

	// Simple field (toState)
	lengthInBits += m.ToState.GetLengthInBits(ctx)

	// Optional Field (eventValues)
	if m.EventValues != nil {
		lengthInBits += m.EventValues.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetUnconfirmedServiceRequest, serviceRequestLength uint16) (__bACnetUnconfirmedServiceRequestUnconfirmedEventNotification BACnetUnconfirmedServiceRequestUnconfirmedEventNotification, err error) {
	m.BACnetUnconfirmedServiceRequestContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetUnconfirmedServiceRequestUnconfirmedEventNotification"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	processIdentifier, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "processIdentifier", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'processIdentifier' field"))
	}
	m.ProcessIdentifier = processIdentifier

	initiatingDeviceIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "initiatingDeviceIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'initiatingDeviceIdentifier' field"))
	}
	m.InitiatingDeviceIdentifier = initiatingDeviceIdentifier

	eventObjectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "eventObjectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventObjectIdentifier' field"))
	}
	m.EventObjectIdentifier = eventObjectIdentifier

	timestamp, err := ReadSimpleField[BACnetTimeStampEnclosed](ctx, "timestamp", ReadComplex[BACnetTimeStampEnclosed](BACnetTimeStampEnclosedParseWithBufferProducer((uint8)(uint8(3))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	notificationClass, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "notificationClass", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(4)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notificationClass' field"))
	}
	m.NotificationClass = notificationClass

	priority, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "priority", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(5)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priority' field"))
	}
	m.Priority = priority

	eventType, err := ReadSimpleField[BACnetEventTypeTagged](ctx, "eventType", ReadComplex[BACnetEventTypeTagged](BACnetEventTypeTaggedParseWithBufferProducer((uint8)(uint8(6)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventType' field"))
	}
	m.EventType = eventType

	var messageText BACnetContextTagCharacterString
	_messageText, err := ReadOptionalField[BACnetContextTagCharacterString](ctx, "messageText", ReadComplex[BACnetContextTagCharacterString](BACnetContextTagParseWithBufferProducer[BACnetContextTagCharacterString]((uint8)(uint8(7)), (BACnetDataType)(BACnetDataType_CHARACTER_STRING)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageText' field"))
	}
	if _messageText != nil {
		messageText = *_messageText
		m.MessageText = messageText
	}

	notifyType, err := ReadSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", ReadComplex[BACnetNotifyTypeTagged](BACnetNotifyTypeTaggedParseWithBufferProducer((uint8)(uint8(8)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notifyType' field"))
	}
	m.NotifyType = notifyType

	var ackRequired BACnetContextTagBoolean
	_ackRequired, err := ReadOptionalField[BACnetContextTagBoolean](ctx, "ackRequired", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(9)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'ackRequired' field"))
	}
	if _ackRequired != nil {
		ackRequired = *_ackRequired
		m.AckRequired = ackRequired
	}

	var fromState BACnetEventStateTagged
	_fromState, err := ReadOptionalField[BACnetEventStateTagged](ctx, "fromState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(10)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'fromState' field"))
	}
	if _fromState != nil {
		fromState = *_fromState
		m.FromState = fromState
	}

	toState, err := ReadSimpleField[BACnetEventStateTagged](ctx, "toState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(11)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'toState' field"))
	}
	m.ToState = toState

	var eventValues BACnetNotificationParameters
	_eventValues, err := ReadOptionalField[BACnetNotificationParameters](ctx, "eventValues", ReadComplex[BACnetNotificationParameters](BACnetNotificationParametersParseWithBufferProducer[BACnetNotificationParameters]((uint8)(uint8(12)), (BACnetObjectType)(eventObjectIdentifier.GetObjectType())), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventValues' field"))
	}
	if _eventValues != nil {
		eventValues = *_eventValues
		m.EventValues = eventValues
	}

	if closeErr := readBuffer.CloseContext("BACnetUnconfirmedServiceRequestUnconfirmedEventNotification"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification")
	}

	return m, nil
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetUnconfirmedServiceRequestUnconfirmedEventNotification"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "processIdentifier", m.GetProcessIdentifier(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'processIdentifier' field")
		}

		if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "initiatingDeviceIdentifier", m.GetInitiatingDeviceIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'initiatingDeviceIdentifier' field")
		}

		if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "eventObjectIdentifier", m.GetEventObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventObjectIdentifier' field")
		}

		if err := WriteSimpleField[BACnetTimeStampEnclosed](ctx, "timestamp", m.GetTimestamp(), WriteComplex[BACnetTimeStampEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "notificationClass", m.GetNotificationClass(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notificationClass' field")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "priority", m.GetPriority(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'priority' field")
		}

		if err := WriteSimpleField[BACnetEventTypeTagged](ctx, "eventType", m.GetEventType(), WriteComplex[BACnetEventTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventType' field")
		}

		if err := WriteOptionalField[BACnetContextTagCharacterString](ctx, "messageText", GetRef(m.GetMessageText()), WriteComplex[BACnetContextTagCharacterString](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'messageText' field")
		}

		if err := WriteSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", m.GetNotifyType(), WriteComplex[BACnetNotifyTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notifyType' field")
		}

		if err := WriteOptionalField[BACnetContextTagBoolean](ctx, "ackRequired", GetRef(m.GetAckRequired()), WriteComplex[BACnetContextTagBoolean](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'ackRequired' field")
		}

		if err := WriteOptionalField[BACnetEventStateTagged](ctx, "fromState", GetRef(m.GetFromState()), WriteComplex[BACnetEventStateTagged](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'fromState' field")
		}

		if err := WriteSimpleField[BACnetEventStateTagged](ctx, "toState", m.GetToState(), WriteComplex[BACnetEventStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'toState' field")
		}

		if err := WriteOptionalField[BACnetNotificationParameters](ctx, "eventValues", GetRef(m.GetEventValues()), WriteComplex[BACnetNotificationParameters](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'eventValues' field")
		}

		if popErr := writeBuffer.PopContext("BACnetUnconfirmedServiceRequestUnconfirmedEventNotification"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetUnconfirmedServiceRequestUnconfirmedEventNotification")
		}
		return nil
	}
	return m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) IsBACnetUnconfirmedServiceRequestUnconfirmedEventNotification() {
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) deepCopy() *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification {
	if m == nil {
		return nil
	}
	_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationCopy := &_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification{
		m.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest).deepCopy(),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.ProcessIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.InitiatingDeviceIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.EventObjectIdentifier),
		utils.DeepCopy[BACnetTimeStampEnclosed](m.Timestamp),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.NotificationClass),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.Priority),
		utils.DeepCopy[BACnetEventTypeTagged](m.EventType),
		utils.DeepCopy[BACnetContextTagCharacterString](m.MessageText),
		utils.DeepCopy[BACnetNotifyTypeTagged](m.NotifyType),
		utils.DeepCopy[BACnetContextTagBoolean](m.AckRequired),
		utils.DeepCopy[BACnetEventStateTagged](m.FromState),
		utils.DeepCopy[BACnetEventStateTagged](m.ToState),
		utils.DeepCopy[BACnetNotificationParameters](m.EventValues),
	}
	_BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationCopy.BACnetUnconfirmedServiceRequestContract.(*_BACnetUnconfirmedServiceRequest)._SubType = m
	return _BACnetUnconfirmedServiceRequestUnconfirmedEventNotificationCopy
}

func (m *_BACnetUnconfirmedServiceRequestUnconfirmedEventNotification) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
