/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.segment;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseText;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.segment.SegmentMergeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMergeFilters {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SegmentMergeFilter[] filters;

    public SegmentMergeFilters(Configuration conf) {
        try {
            ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(SegmentMergeFilter.X_POINT_ID);
            if (point == null) {
                throw new RuntimeException(URLFilter.X_POINT_ID + " not found.");
            }
            Extension[] extensions = point.getExtensions();
            this.filters = new SegmentMergeFilter[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                this.filters[i] = (SegmentMergeFilter)extensions[i].getExtensionInstance();
            }
        }
        catch (PluginRuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean filter(Text key, CrawlDatum generateData, CrawlDatum fetchData, CrawlDatum sigData, Content content, ParseData parseData, ParseText parseText, Collection<CrawlDatum> linked) {
        for (SegmentMergeFilter filter : this.filters) {
            if (filter.filter(key, generateData, fetchData, sigData, content, parseData, parseText, linked)) continue;
            LOG.trace("Key {} dropped by {}", (Object)key, (Object)filter.getClass().getName());
            return false;
        }
        LOG.trace("Key {} accepted for merge.", (Object)key);
        return true;
    }
}

