/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.mimetypes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MimeTypeDetector {
    private static String[] XML_MIMETYPES = new String[]{"application/xml", "application/x-xml", "text/xml", "application/atom+xml", "application/rss+xml", "text/rss", "application/rdf+xml"};
    private static String[] TEXT_MIMETYPES = new String[]{"text/plain"};
    private static String[] GZIP_MIMETYPES = new String[]{"application/gzip", "application/gzip-compressed", "application/gzipped", "application/x-gzip", "application/x-gzip-compressed", "application/x-gunzip", "gzip/document"};
    private static String[][] MIMETYPES = new String[][]{XML_MIMETYPES, TEXT_MIMETYPES, GZIP_MIMETYPES};
    private static byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static final int LEADING_WHITESPACE_MAX_SKIP = 32;
    private static final boolean[] spaceCharacters = new boolean[256];
    private List<MimeTypeEntry> mimeTypes = new ArrayList<MimeTypeEntry>();
    private int maxPatternLength;

    public MimeTypeDetector() {
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<?xml", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<?XML", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<!--", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<urlset", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<sitemapindex", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<rss", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<feed", true));
        this.mimeTypes.add(new MimeTypeEntry(XML_MIMETYPES[0], "<rdf", true));
        this.mimeTypes.add(new MimeTypeEntry(TEXT_MIMETYPES[0], "http://", true));
        this.mimeTypes.add(new MimeTypeEntry(TEXT_MIMETYPES[0], "https://", true));
        this.mimeTypes.add(new MimeTypeEntry(GZIP_MIMETYPES[0], "\u001f\u008b"));
        this.mimeTypes.add(new MimeTypeEntry(GZIP_MIMETYPES[0], 31, 139));
        this.maxPatternLength = 0;
        for (MimeTypeEntry entry : this.mimeTypes) {
            int length = entry.getPattern().length;
            if (entry.isTextPattern) {
                length += 32;
            }
            this.maxPatternLength = Math.max(this.maxPatternLength, length);
        }
    }

    public String detect(byte[] content) {
        return this.detect(content, content.length);
    }

    public String detect(byte[] content, int length) {
        int offsetText = -1;
        for (MimeTypeEntry entry : this.mimeTypes) {
            if (entry.isTextPattern) {
                if (offsetText == -1) {
                    for (offsetText = 0; this.patternMatches(UTF8_BOM, content, offsetText, length) && offsetText < content.length; offsetText += UTF8_BOM.length) {
                    }
                    while (offsetText < content.length && spaceCharacters[content[offsetText] & 0xFF]) {
                        ++offsetText;
                    }
                }
                if (!this.patternMatches(entry.getPattern(), content, offsetText, length - offsetText)) continue;
                return entry.getMimeType();
            }
            if (!this.patternMatches(entry.getPattern(), content, 0, length)) continue;
            return entry.getMimeType();
        }
        return null;
    }

    private boolean patternMatches(byte[] pattern, byte[] content, int offset, int length) {
        if (pattern.length > length) {
            return false;
        }
        for (int i = 0; i < pattern.length && offset + i < content.length; ++i) {
            if (pattern[i] == content[offset + i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String detect(InputStream is) throws IOException {
        if (!is.markSupported()) {
            throw new IllegalArgumentException("Can't detect mime type for input stream that doesn't support mark/reset");
        }
        is.mark(this.maxPatternLength);
        byte[] content = new byte[this.maxPatternLength];
        try {
            int contentLength = is.read(content);
            String string = this.detect(content, contentLength);
            return string;
        }
        finally {
            is.reset();
        }
    }

    public boolean isXml(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        for (String xmlMimeType : XML_MIMETYPES) {
            if (!mimeType.equals(xmlMimeType)) continue;
            return true;
        }
        return false;
    }

    public boolean isText(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        for (String textMimeType : TEXT_MIMETYPES) {
            if (!mimeType.equals(textMimeType)) continue;
            return true;
        }
        return false;
    }

    public boolean isGzip(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        for (String gzipMimeType : GZIP_MIMETYPES) {
            if (!mimeType.equals(gzipMimeType)) continue;
            return true;
        }
        return false;
    }

    public String normalize(String contentType, byte[] content) {
        String normalizedContentType = contentType.toLowerCase(Locale.ROOT);
        String[][] stringArray = MIMETYPES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] mimeTypes;
            for (String mimeType : mimeTypes = stringArray[i]) {
                if (!normalizedContentType.equals(mimeType)) continue;
                return mimeTypes[0];
            }
        }
        String result = this.detect(content);
        if (result != null) {
            return result;
        }
        return null;
    }

    static {
        MimeTypeDetector.spaceCharacters[9] = true;
        MimeTypeDetector.spaceCharacters[10] = true;
        MimeTypeDetector.spaceCharacters[11] = true;
        MimeTypeDetector.spaceCharacters[12] = true;
        MimeTypeDetector.spaceCharacters[13] = true;
        MimeTypeDetector.spaceCharacters[32] = true;
    }

    private static class MimeTypeEntry {
        private String mimeType;
        private byte[] pattern;
        private boolean isTextPattern;

        public MimeTypeEntry(String mimeType, String pattern) {
            this(mimeType, pattern, false);
        }

        public MimeTypeEntry(String mimeType, String pattern, boolean isTextPattern) {
            this.mimeType = mimeType;
            this.isTextPattern = isTextPattern;
            this.pattern = pattern.getBytes(StandardCharsets.UTF_8);
        }

        public MimeTypeEntry(String mimeType, int ... pattern) {
            this.mimeType = mimeType;
            this.pattern = this.makeBytePattern(pattern);
        }

        private byte[] makeBytePattern(int[] pattern) {
            byte[] result = new byte[pattern.length];
            for (int i = 0; i < pattern.length; ++i) {
                result[i] = (byte)(pattern[i] & 0xFF);
            }
            return result;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public byte[] getPattern() {
            return this.pattern;
        }
    }
}

