/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomTreeWalker;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.w3c.dom.DOMException;
import org.w3c.dom.traversal.NodeFilter;

@JsxClass
public class TreeWalker
extends HtmlUnitScriptable {
    private DomTreeWalker walker_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public TreeWalker() {
    }

    public TreeWalker(SgmlPage page, Node root, int whatToShow, NodeFilter filter, boolean expandEntityReferences) throws DOMException {
        if (root == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(9, "root must not be null"));
        }
        this.walker_ = page.createTreeWalker(root.getDomNodeOrDie(), whatToShow, filter, expandEntityReferences);
    }

    @JsxGetter
    public Node getRoot() {
        return TreeWalker.getNodeOrNull(this.walker_.getRoot());
    }

    @JsxGetter
    public long getWhatToShow() {
        long whatToShow = this.walker_.getWhatToShow();
        if (whatToShow == -1L) {
            whatToShow = 0xFFFFFFFFL;
        }
        return whatToShow;
    }

    @JsxGetter
    public Object getFilter() {
        return this.walker_.getFilter();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isExpandEntityReferences() {
        return this.walker_.getExpandEntityReferences();
    }

    @JsxGetter
    public Node getCurrentNode() {
        return TreeWalker.getNodeOrNull(this.walker_.getCurrentNode());
    }

    @JsxSetter
    public void setCurrentNode(Node currentNode) throws DOMException {
        if (currentNode == null) {
            throw new DOMException(9, "currentNode cannot be set to null");
        }
        this.walker_.setCurrentNode(currentNode.getDomNodeOrDie());
    }

    static int getFlagForNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 11: {
                return 1024;
            }
            case 12: {
                return 2048;
            }
        }
        return 0;
    }

    @JsxFunction
    public Node parentNode() {
        return TreeWalker.getNodeOrNull(this.walker_.parentNode());
    }

    private static Node getNodeOrNull(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (Node)domNode.getScriptableObject();
    }

    @JsxFunction
    public Node firstChild() {
        return TreeWalker.getNodeOrNull(this.walker_.firstChild());
    }

    @JsxFunction
    public Node lastChild() {
        return TreeWalker.getNodeOrNull(this.walker_.lastChild());
    }

    @JsxFunction
    public Node previousSibling() {
        return TreeWalker.getNodeOrNull(this.walker_.previousSibling());
    }

    @JsxFunction
    public Node nextSibling() {
        return TreeWalker.getNodeOrNull(this.walker_.nextSibling());
    }

    @JsxFunction
    public Node previousNode() {
        return TreeWalker.getNodeOrNull(this.walker_.previousNode());
    }

    @JsxFunction
    public Node nextNode() {
        return TreeWalker.getNodeOrNull(this.walker_.nextNode());
    }
}

