/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import jakarta.faces.application.NavigationHandler;
import jakarta.faces.context.FacesContext;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugNavigationHandler
extends NavigationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NavigationHandler navigationHandler;

    public DebugNavigationHandler(NavigationHandler navigationHandler) {
        this.navigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handle Navigation context: " + String.valueOf(facesContext) + " fromAction: '" + fromAction + "' outcome: '" + outcome + "'");
        }
        if (outcome != null && facesContext.getPartialViewContext().isAjaxRequest()) {
            LOG.warn("An AJAX-Request should not have an outcome set: outcome='" + outcome + "'");
        }
        this.navigationHandler.handleNavigation(facesContext, fromAction, outcome);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handled Navigation context: " + String.valueOf(facesContext) + " fromAction: '" + fromAction + "' outcome: '" + outcome + "'");
        }
    }
}

