/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.MetaRuleset;
import java.util.HashSet;
import java.util.Map;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.event.TabChangeSource;
import org.apache.myfaces.tobago.facelets.SheetStateChangeSourceRule;
import org.apache.myfaces.tobago.facelets.SortActionSourceRule;
import org.apache.myfaces.tobago.facelets.SupportsMarkupRule;
import org.apache.myfaces.tobago.facelets.TabChangeSourceRule;

public class TobagoComponentHandler
extends ComponentHandler {
    public TobagoComponentHandler(ComponentConfig componentConfig) {
        super(componentConfig);
    }

    protected MetaRuleset createMetaRuleset(Class aClass) {
        MetaRuleset metaRuleset = super.createMetaRuleset(aClass);
        if (SortActionSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SortActionSourceRule.INSTANCE);
        }
        if (TabChangeSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)TabChangeSourceRule.INSTANCE);
        }
        if (SheetStateChangeSource.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SheetStateChangeSourceRule.INSTANCE);
        }
        if (Visual.class.isAssignableFrom(aClass)) {
            metaRuleset.addRule((MetaRule)SupportsMarkupRule.INSTANCE);
        }
        return metaRuleset;
    }

    public void onComponentPopulated(FaceletContext context, UIComponent component, UIComponent parent) {
        if (component instanceof EditableValueHolder) {
            this.addDefaultValidators(context.getFacesContext(), (EditableValueHolder)component);
        }
    }

    private void addDefaultValidators(FacesContext facesContext, EditableValueHolder component) {
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        Map<String, String> validatorInfoMap = tobagoConfig.getDefaultValidatorInfo();
        if (validatorInfoMap.isEmpty()) {
            return;
        }
        Validator[] validators = component.getValidators();
        if (validators.length > 0) {
            HashSet<String> classNames = new HashSet<String>();
            for (Validator validator : validators) {
                classNames.add(validator.getClass().getName());
            }
            validatorInfoMap.forEach((key, value) -> {
                if (!classNames.contains(value)) {
                    component.addValidator(facesContext.getApplication().createValidator(key));
                }
            });
        } else {
            for (String next : validatorInfoMap.keySet()) {
                component.addValidator(facesContext.getApplication().createValidator(next));
            }
        }
    }
}

