/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;

public class DSSPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder<DSAPublicKey, DSAPrivateKey> {
    public static final DSSPublicKeyEntryDecoder INSTANCE = new DSSPublicKeyEntryDecoder();

    public DSSPublicKeyEntryDecoder() {
        super(DSAPublicKey.class, DSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-dss")));
    }

    @Override
    public DSAPublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (!"ssh-dss".equals(keyType)) {
            throw new InvalidKeySpecException("Unexpected key type: " + keyType);
        }
        BigInteger p = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger q = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger g = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger y = KeyEntryResolver.decodeBigInt(keyData);
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(y, p, q, g));
    }

    @Override
    public String encodePublicKey(OutputStream s, DSAPublicKey key) throws IOException {
        Objects.requireNonNull(key, "No public key provided");
        DSAParams keyParams = Objects.requireNonNull(key.getParams(), "No DSA params available");
        KeyEntryResolver.encodeString(s, "ssh-dss");
        KeyEntryResolver.encodeBigInt(s, keyParams.getP());
        KeyEntryResolver.encodeBigInt(s, keyParams.getQ());
        KeyEntryResolver.encodeBigInt(s, keyParams.getG());
        KeyEntryResolver.encodeBigInt(s, key.getY());
        return "ssh-dss";
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("DSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("DSA");
    }
}

