/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.ops4j.pax.url.mvn.internal.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.lang.NullArgumentException;

public class Connection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private final MavenResolver m_resolver;

    public Connection(URL url, MavenResolver resolver) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL cannot be null");
        NullArgumentException.validateNotNull(resolver, "Service configuration");
        this.m_resolver = resolver;
        new Parser(url.getPath());
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug("Resolving [" + this.url.toExternalForm() + "]");
        File file = this.m_resolver.resolve(this.url.toExternalForm());
        return new FileInputStream(file);
    }
}

