/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.UniVocityFixedWidthDataFormat;
import org.apache.camel.model.dataformat.UniVocityHeader;
import org.apache.camel.reifier.dataformat.UniVocityAbstractDataFormatReifier;

public class UniVocityFixedWidthDataFormatReifier
extends UniVocityAbstractDataFormatReifier<UniVocityFixedWidthDataFormat> {
    public UniVocityFixedWidthDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        super.prepareDataFormatConfig(properties);
        properties.put("fieldLengths", this.getFieldLengths());
        properties.put("skipTrailingCharsUntilNewline", ((UniVocityFixedWidthDataFormat)this.definition).getSkipTrailingCharsUntilNewline());
        properties.put("recordEndsOnNewline", ((UniVocityFixedWidthDataFormat)this.definition).getRecordEndsOnNewline());
        properties.put("padding", ((UniVocityFixedWidthDataFormat)this.definition).getPadding());
    }

    private int[] getFieldLengths() {
        if (((UniVocityFixedWidthDataFormat)this.definition).getHeaders() != null) {
            int i = 0;
            int[] arr = new int[((UniVocityFixedWidthDataFormat)this.definition).getHeaders().size()];
            for (UniVocityHeader header : ((UniVocityFixedWidthDataFormat)this.definition).getHeaders()) {
                String len = header.getLength();
                int num = Integer.parseInt(len);
                arr[i++] = num;
            }
            return arr;
        }
        return null;
    }
}

