/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.Iterator;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.TripleCollector;
import org.apache.jena.sparql.syntax.TripleCollectorMark;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class ElementPathBlock
extends Element
implements TripleCollector,
TripleCollectorMark {
    private PathBlock pattern = new PathBlock();

    public ElementPathBlock() {
    }

    public ElementPathBlock(PathBlock pattern) {
        this.pattern = pattern;
    }

    public ElementPathBlock(BasicPattern bgp) {
        for (Triple t : bgp.getList()) {
            this.addTriple(t);
        }
    }

    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public void addTriple(TriplePath tp) {
        this.pattern.add(tp);
    }

    @Override
    public int mark() {
        return this.pattern.size();
    }

    @Override
    public void addTriple(Triple t) {
        this.addTriplePath(new TriplePath(t));
    }

    @Override
    public void addTriple(int index, Triple t) {
        this.addTriplePath(index, new TriplePath(t));
    }

    @Override
    public void addTriplePath(TriplePath tPath) {
        this.pattern.add(tPath);
    }

    @Override
    public void addTriplePath(int index, TriplePath tPath) {
        this.pattern.add(index, tPath);
    }

    public PathBlock getPattern() {
        return this.pattern;
    }

    public Iterator<TriplePath> patternElts() {
        return this.pattern.iterator();
    }

    @Override
    public int hashCode() {
        int calcHashCode = 161;
        return calcHashCode ^= this.pattern.hashCode();
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementPathBlock)) {
            return false;
        }
        ElementPathBlock eg2 = (ElementPathBlock)el2;
        return this.pattern.equiv(eg2.pattern, isoMap);
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

