/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;

public abstract class IteratorDelayedInitialization<T>
implements IteratorCloseable<T> {
    private boolean initialized = false;
    private Iterator<T> iterator;

    private void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.iterator = this.initializeIterator();
        }
    }

    protected abstract Iterator<T> initializeIterator();

    @Override
    public boolean hasNext() {
        this.init();
        boolean b = this.iterator.hasNext();
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public T next() {
        this.init();
        try {
            return this.iterator.next();
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.init();
        this.iterator.forEachRemaining(action);
        this.close();
    }

    @Override
    public void remove() {
        this.init();
        this.iterator.remove();
    }

    @Override
    public void close() {
        Iter.close(this.iterator);
        this.iterator = null;
    }
}

