/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.FileNotFoundException;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.utils.PropertiesProvider;

public enum MailQueueChoice {
    RABBITMQ,
    PULSAR;


    public static MailQueueChoice parse(Configuration configuration) {
        return Optional.ofNullable(configuration.getString("mail.queue.choice", null)).map(MailQueueChoice::valueOf).orElse(RABBITMQ);
    }

    public static MailQueueChoice parse(PropertiesProvider configuration) {
        try {
            return MailQueueChoice.parse(configuration.getConfiguration("queue"));
        }
        catch (FileNotFoundException e) {
            return RABBITMQ;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

