/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinBaseDN
implements Serializable {
    public static final byte BASE_TYPE_SEARCH_BASE = -128;
    public static final byte BASE_TYPE_SOURCE_ENTRY_DN = -127;
    public static final byte BASE_TYPE_CUSTOM = -126;
    @NotNull
    private static final JoinBaseDN USE_SEARCH_BASE_DN = new JoinBaseDN(-128, null);
    @NotNull
    private static final JoinBaseDN USE_SOURCE_ENTRY_DN = new JoinBaseDN(-127, null);
    private static final long serialVersionUID = -330303461586380445L;
    private final byte type;
    @Nullable
    private final String customBaseDN;

    private JoinBaseDN(byte type, @Nullable String customBaseDN) {
        this.type = type;
        this.customBaseDN = customBaseDN;
    }

    @NotNull
    public static JoinBaseDN createUseSearchBaseDN() {
        return USE_SEARCH_BASE_DN;
    }

    @NotNull
    public static JoinBaseDN createUseSourceEntryDN() {
        return USE_SOURCE_ENTRY_DN;
    }

    @NotNull
    public static JoinBaseDN createUseCustomBaseDN(@NotNull String baseDN) {
        Validator.ensureNotNull(baseDN);
        return new JoinBaseDN(-126, baseDN);
    }

    public byte getType() {
        return this.type;
    }

    @Nullable
    public String getCustomBaseDN() {
        return this.customBaseDN;
    }

    @NotNull
    ASN1Element encode() {
        switch (this.type) {
            case -128: 
            case -127: {
                return new ASN1Null(this.type);
            }
            case -126: {
                return new ASN1OctetString(this.type, this.customBaseDN);
            }
        }
        return null;
    }

    @NotNull
    static JoinBaseDN decode(@NotNull ASN1Element element) throws LDAPException {
        switch (element.getType()) {
            case -128: {
                return USE_SEARCH_BASE_DN;
            }
            case -127: {
                return USE_SOURCE_ENTRY_DN;
            }
            case -126: {
                return new JoinBaseDN(element.getType(), element.decodeAsOctetString().stringValue());
            }
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_BASE_DECODE_INVALID_TYPE.get(StaticUtils.toHex(element.getType())));
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        switch (this.type) {
            case -128: {
                buffer.append("useSearchBaseDN");
                break;
            }
            case -127: {
                buffer.append("useSourceEntryDN");
                break;
            }
            case -126: {
                buffer.append("useCustomBaseDN(baseDN='");
                buffer.append(this.customBaseDN);
                buffer.append("')");
            }
        }
    }
}

