/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import java.net.URL;
import java.util.Optional;
import org.apache.james.jwt.JwksPublicKeyProvider;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.jwt.PublicKeyProvider;

public class OidcJwtTokenVerifier {
    public Optional<String> verifyAndExtractClaim(String jwtToken, URL jwksURL, String claimName) {
        PublicKeyProvider jwksPublicKeyProvider = OidcJwtTokenVerifier.getClaimWithoutSignatureVerification(jwtToken, "kid", String.class).map(kidValue -> JwksPublicKeyProvider.of(jwksURL, kidValue)).orElse(JwksPublicKeyProvider.of(jwksURL));
        return new JwtTokenVerifier(jwksPublicKeyProvider).verifyAndExtractClaim(jwtToken, claimName, String.class);
    }

    public static <T> Optional<T> getClaimWithoutSignatureVerification(String token, String claimName, Class<T> returnType) {
        int signatureIndex = token.lastIndexOf(46);
        if (signatureIndex <= 0) {
            return Optional.empty();
        }
        String nonSignedToken = token.substring(0, signatureIndex + 1);
        try {
            Jwt headerClaims = Jwts.parser().parseClaimsJwt(nonSignedToken);
            Object claim = headerClaims.getHeader().get((Object)claimName);
            if (claim == null) {
                throw new MalformedJwtException("'" + claimName + "' field in token is mandatory");
            }
            return Optional.of(claim);
        }
        catch (JwtException e) {
            return Optional.empty();
        }
    }
}

