/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.outlierdetection.AbstractConfusionMatrixMetric;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ConfusionMatrixMetric
extends AbstractConfusionMatrixMetric {
    public static final String NAME = "confusion_matrix";
    private static final ConstructingObjectParser<ConfusionMatrixMetric, Void> PARSER = new ConstructingObjectParser("confusion_matrix", args -> new ConfusionMatrixMetric((List)args[0]));

    public static ConfusionMatrixMetric fromXContent(XContentParser parser) {
        return (ConfusionMatrixMetric)PARSER.apply(parser, null);
    }

    public static ConfusionMatrixMetric at(Double ... at) {
        return new ConfusionMatrixMetric(Arrays.asList(at));
    }

    public ConfusionMatrixMetric(List<Double> at) {
        super(at);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfusionMatrixMetric that = (ConfusionMatrixMetric)o;
        return Arrays.equals(this.thresholds, that.thresholds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.thresholds);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), AT);
    }

    public static final class ConfusionMatrix
    implements ToXContentObject {
        private static final ParseField TP = new ParseField("tp", new String[0]);
        private static final ParseField FP = new ParseField("fp", new String[0]);
        private static final ParseField TN = new ParseField("tn", new String[0]);
        private static final ParseField FN = new ParseField("fn", new String[0]);
        private static final ConstructingObjectParser<ConfusionMatrix, Void> PARSER = new ConstructingObjectParser("confusion_matrix", true, args -> new ConfusionMatrix((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3]));
        private final long tp;
        private final long fp;
        private final long tn;
        private final long fn;

        public static ConfusionMatrix fromXContent(XContentParser parser) {
            return (ConfusionMatrix)PARSER.apply(parser, null);
        }

        public ConfusionMatrix(long tp, long fp, long tn, long fn) {
            this.tp = tp;
            this.fp = fp;
            this.tn = tn;
            this.fn = fn;
        }

        public long getTruePositives() {
            return this.tp;
        }

        public long getFalsePositives() {
            return this.fp;
        }

        public long getTrueNegatives() {
            return this.tn;
        }

        public long getFalseNegatives() {
            return this.fn;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(TP.getPreferredName(), this.tp).field(FP.getPreferredName(), this.fp).field(TN.getPreferredName(), this.tn).field(FN.getPreferredName(), this.fn).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfusionMatrix that = (ConfusionMatrix)o;
            return this.tp == that.tp && this.fp == that.fp && this.tn == that.tn && this.fn == that.fn;
        }

        public int hashCode() {
            return Objects.hash(this.tp, this.fp, this.tn, this.fn);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TP);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FP);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TN);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), FN);
        }
    }

    public static class Result
    implements EvaluationMetric.Result {
        private final Map<String, ConfusionMatrix> results;

        public static Result fromXContent(XContentParser parser) throws IOException {
            return new Result(parser.map(LinkedHashMap::new, ConfusionMatrix::fromXContent));
        }

        public Result(Map<String, ConfusionMatrix> results) {
            this.results = Objects.requireNonNull(results);
        }

        @Override
        public String getMetricName() {
            return ConfusionMatrixMetric.NAME;
        }

        public ConfusionMatrix getScoreByThreshold(String threshold) {
            return this.results.get(threshold);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.results);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.results, that.results);
        }

        public int hashCode() {
            return Objects.hash(this.results);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

