/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.fastfail.AbstractGreylistHandler;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.util.DurationParser;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCGreylistHandler
extends AbstractGreylistHandler
implements ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCGreylistHandler.class);
    private DataSource datasource = null;
    private FileSystem fileSystem = null;
    private String selectQuery;
    private String insertQuery;
    private String deleteQuery;
    private String deleteAutoWhiteListQuery;
    private String updateQuery;
    private final SqlResources sqlQueries = new SqlResources();
    private String sqlFileUrl;
    private final Map<String, String> sqlParameters = new HashMap<String, String>();
    private DNSService dnsService;
    private NetMatcher wNetworks;
    private final JDBCUtil theJDBCUtil = new JDBCUtil();

    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Inject
    public void setFileSystem(FileSystem system) {
        this.fileSystem = system;
    }

    @Inject
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void setSqlFileUrl(String sqlFileUrl) {
        this.sqlFileUrl = sqlFileUrl;
    }

    public void setTempBlockTime(String tempBlockTime) {
        this.setTempBlockTime(DurationParser.parse((String)tempBlockTime));
    }

    public void setAutoWhiteListLifeTime(String autoWhiteListLifeTime) {
        this.setAutoWhiteListLifeTime(DurationParser.parse((String)autoWhiteListLifeTime));
    }

    public void setUnseenLifeTime(String unseenLifeTime) {
        this.setUnseenLifeTime(DurationParser.parse((String)unseenLifeTime));
    }

    @Inject
    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    protected NetMatcher getWhiteListedNetworks() {
        return this.wNetworks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<String> getGreyListData(String ipAddress, String sender, String recip) throws SQLException {
        ArrayList<String> data = new ArrayList<String>(2);
        PreparedStatement mappingStmt = null;
        Connection conn = this.datasource.getConnection();
        try {
            ResultSet mappingRS;
            block5: {
                mappingStmt = conn.prepareStatement(this.selectQuery);
                mappingRS = null;
                try {
                    mappingStmt.setString(1, ipAddress);
                    mappingStmt.setString(2, sender);
                    mappingStmt.setString(3, recip);
                    mappingRS = mappingStmt.executeQuery();
                    if (!mappingRS.next()) break block5;
                    data.add(String.valueOf(mappingRS.getTimestamp(1).getTime()));
                    data.add(String.valueOf(mappingRS.getInt(2)));
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                    throw throwable;
                }
            }
            this.theJDBCUtil.closeJDBCResultSet(mappingRS);
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
        return data.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertTriplet(String ipAddress, String sender, String recip, int count, Instant createTime) throws SQLException {
        Connection conn = this.datasource.getConnection();
        PreparedStatement mappingStmt = null;
        try {
            mappingStmt = conn.prepareStatement(this.insertQuery);
            mappingStmt.setString(1, ipAddress);
            mappingStmt.setString(2, sender);
            mappingStmt.setString(3, recip);
            mappingStmt.setInt(4, count);
            mappingStmt.setTimestamp(5, new Timestamp(createTime.getEpochSecond()));
            mappingStmt.executeUpdate();
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTriplet(String ipAddress, String sender, String recip, int count, Instant time) throws SQLException {
        Connection conn = this.datasource.getConnection();
        PreparedStatement mappingStmt = null;
        try {
            mappingStmt = conn.prepareStatement(this.updateQuery);
            mappingStmt.setTimestamp(1, new Timestamp(time.getEpochSecond()));
            mappingStmt.setInt(2, count + 1);
            mappingStmt.setString(3, ipAddress);
            mappingStmt.setString(4, sender);
            mappingStmt.setString(5, recip);
            mappingStmt.executeUpdate();
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAutoWhiteListGreyList(Instant time) throws SQLException {
        PreparedStatement mappingStmt = null;
        Connection conn = this.datasource.getConnection();
        try {
            mappingStmt = conn.prepareStatement(this.deleteAutoWhiteListQuery);
            mappingStmt.setTimestamp(1, new Timestamp(time.getEpochSecond()));
            mappingStmt.executeUpdate();
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupGreyList(Instant time) throws SQLException {
        Connection conn = this.datasource.getConnection();
        PreparedStatement mappingStmt = null;
        try {
            mappingStmt = conn.prepareStatement(this.deleteQuery);
            mappingStmt.setTimestamp(1, new Timestamp(time.getEpochSecond()));
            mappingStmt.executeUpdate();
        }
        finally {
            this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSqlQueries(Connection conn, String sqlFileUrl) throws Exception {
        try {
            File sqlFile;
            try {
                sqlFile = this.fileSystem.getFile(sqlFileUrl);
                sqlFileUrl = null;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            this.sqlQueries.init(sqlFile.getCanonicalFile(), "GreyList", conn, this.sqlParameters);
            this.selectQuery = this.sqlQueries.getSqlString("selectQuery", true);
            this.insertQuery = this.sqlQueries.getSqlString("insertQuery", true);
            this.deleteQuery = this.sqlQueries.getSqlString("deleteQuery", true);
            this.deleteAutoWhiteListQuery = this.sqlQueries.getSqlString("deleteAutoWhitelistQuery", true);
            this.updateQuery = this.sqlQueries.getSqlString("updateQuery", true);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(String tableNameSqlStringName, String createSqlStringName) throws SQLException {
        Connection conn = this.datasource.getConnection();
        try {
            String tableName = this.sqlQueries.getSqlString(tableNameSqlStringName, true);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                boolean bl = false;
                return bl;
            }
            PreparedStatement createStatement = null;
            try {
                createStatement = conn.prepareStatement(this.sqlQueries.getSqlString(createSqlStringName, true));
                createStatement.execute();
                LOGGER.info("Created table '{}' using sqlResources string '{}'.", (Object)tableName, (Object)createSqlStringName);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(createStatement);
                throw throwable;
            }
            this.theJDBCUtil.closeJDBCStatement((Statement)createStatement);
            boolean bl = true;
            return bl;
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (this.wNetworks == null || !this.wNetworks.matchInetNetwork(session.getRemoteAddress().getAddress().getHostAddress())) {
            return super.doRcpt(session, sender, rcpt);
        }
        LOGGER.info("IpAddress {} is whitelisted. Skip greylisting.", (Object)session.getRemoteAddress().getAddress().getHostAddress());
        return HookResult.DECLINED;
    }

    public void init(Configuration handlerConfiguration) throws ConfigurationException {
        String sFile;
        try {
            this.setTempBlockTime(handlerConfiguration.getString("tempBlockTime"));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(e.getMessage());
        }
        try {
            this.setAutoWhiteListLifeTime(handlerConfiguration.getString("autoWhiteListLifeTime"));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(e.getMessage());
        }
        try {
            this.setUnseenLifeTime(handlerConfiguration.getString("unseenLifeTime"));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(e.getMessage());
        }
        String nets = handlerConfiguration.getString("whitelistedNetworks");
        if (nets != null) {
            String[] whitelistArray = nets.split(",");
            ArrayList<String> wList = new ArrayList<String>(whitelistArray.length);
            for (String aWhitelistArray : whitelistArray) {
                wList.add(aWhitelistArray.trim());
            }
            this.wNetworks = new NetMatcher(wList, this.dnsService);
            LOGGER.info("Whitelisted addresses: {}", (Object)this.getWhiteListedNetworks());
        }
        if ((sFile = handlerConfiguration.getString("sqlFile", null)) != null) {
            this.setSqlFileUrl(sFile);
            if (!this.sqlFileUrl.startsWith("file://") && !this.sqlFileUrl.startsWith("classpath:")) {
                throw new ConfigurationException("Malformed sqlFile - Must be of the format \"file://<filename>\".");
            }
        } else {
            throw new ConfigurationException("sqlFile is not configured");
        }
        try {
            this.initSqlQueries(this.datasource.getConnection(), this.sqlFileUrl);
            this.createTable("greyListTableName", "createGreyListTable");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to init datasource", e);
        }
    }
}

