/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl;

import com.healthmarketscience.jackcess.crypt.impl.BaseCryptCodecHandler;
import com.healthmarketscience.jackcess.crypt.util.StreamCipherCompat;
import com.healthmarketscience.jackcess.crypt.util.StreamCipherFactory;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.nio.ByteBuffer;

public abstract class BaseJetCryptCodecHandler
extends BaseCryptCodecHandler {
    private StreamCipherCompat _engine;

    protected BaseJetCryptCodecHandler(PageChannel channel, byte[] encodingKey) {
        super(channel, encodingKey);
    }

    @Override
    public boolean canEncodePartialPage() {
        return true;
    }

    @Override
    public boolean canDecodeInline() {
        return true;
    }

    @Override
    protected final StreamCipherCompat getStreamCipher() {
        if (this._engine == null) {
            this._engine = StreamCipherFactory.newRC4Engine();
        }
        return this._engine;
    }

    @Override
    public void decodePage(ByteBuffer inPage, ByteBuffer outPage, int pageNumber) {
        if (!this.isEncryptedPage(pageNumber)) {
            return;
        }
        this.streamDecrypt(inPage, pageNumber);
    }

    @Override
    public ByteBuffer encodePage(ByteBuffer buffer, int pageNumber, int pageOffset) {
        if (!this.isEncryptedPage(pageNumber)) {
            return buffer;
        }
        return this.streamEncrypt(buffer, pageNumber, pageOffset);
    }

    private boolean isEncryptedPage(int pageNumber) {
        return pageNumber > 0 && pageNumber <= this.getMaxEncodedPage();
    }

    protected abstract int getMaxEncodedPage();
}

