/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.payload;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.isession.ISessionDataSet;
import org.apache.iotdb.rpc.subscription.annotation.TableModel;
import org.apache.thrift.annotation.Nullable;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class SubscriptionSessionDataSet
implements ISessionDataSet {
    private Tablet tablet;
    @Nullable
    private final String databaseName;
    @TableModel
    private List<ColumnCategory> columnCategoryList;
    private List<String> columnNameList;
    private List<String> columnTypeList;
    private Iterator<Map.Entry<Long, Integer>> rowIterator;

    public Tablet getTablet() {
        return this.tablet;
    }

    public SubscriptionSessionDataSet(Tablet tablet, @Nullable String databaseName) {
        this.tablet = tablet;
        this.databaseName = databaseName;
        this.generateRowIterator();
    }

    @TableModel
    public String getDatabaseName() {
        return this.databaseName;
    }

    @TableModel
    public String getTableName() {
        return this.tablet.getTableName();
    }

    @TableModel
    public List<ColumnCategory> getColumnCategories() {
        if (Objects.nonNull(this.columnCategoryList)) {
            return this.columnCategoryList;
        }
        if (!this.isTableData()) {
            return Collections.emptyList();
        }
        this.columnCategoryList = Stream.concat(Stream.of(ColumnCategory.TIME), this.tablet.getColumnTypes().stream().map(columnCategory -> {
            switch (columnCategory) {
                case FIELD: {
                    return ColumnCategory.FIELD;
                }
                case TAG: {
                    return ColumnCategory.TAG;
                }
                case ATTRIBUTE: {
                    return ColumnCategory.ATTRIBUTE;
                }
            }
            throw new IllegalArgumentException("Unknown column category: " + columnCategory);
        })).collect(Collectors.toList());
        return this.columnCategoryList;
    }

    private boolean isTableData() {
        return Objects.nonNull(this.databaseName);
    }

    public List<String> getColumnNames() {
        if (Objects.nonNull(this.columnNameList)) {
            return this.columnNameList;
        }
        List schemas = this.tablet.getSchemas();
        String deviceId = this.tablet.getDeviceId();
        this.columnNameList = this.isTableData() ? Stream.concat(Stream.of("time"), schemas.stream().map(IMeasurementSchema::getMeasurementName)).collect(Collectors.toList()) : Stream.concat(Stream.of("Time"), schemas.stream().map(schema -> deviceId + "." + schema.getMeasurementName())).collect(Collectors.toList());
        return this.columnNameList;
    }

    public List<String> getColumnTypes() {
        if (Objects.nonNull(this.columnTypeList)) {
            return this.columnTypeList;
        }
        List schemas = this.tablet.getSchemas();
        this.columnTypeList = Stream.concat(Stream.of(TSDataType.INT64.toString()), schemas.stream().map(schema -> schema.getType().toString())).collect(Collectors.toList());
        return this.columnTypeList;
    }

    public boolean hasNext() {
        return this.rowIterator.hasNext();
    }

    public RowRecord next() {
        Map.Entry<Long, Integer> entry = this.rowIterator.next();
        int columnSize = this.getColumnSize();
        ArrayList<Field> fields = new ArrayList<Field>();
        long timestamp = entry.getKey();
        int rowIndex = entry.getValue();
        BitMap[] bitMaps = this.tablet.getBitMaps();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            Field field;
            if (bitMaps != null && bitMaps[columnIndex] != null && bitMaps[columnIndex].isMarked(rowIndex)) {
                field = new Field(null);
            } else {
                TSDataType dataType = ((IMeasurementSchema)this.tablet.getSchemas().get(columnIndex)).getType();
                field = SubscriptionSessionDataSet.generateFieldFromTabletValue(dataType, this.tablet.getValues()[columnIndex], rowIndex);
            }
            fields.add(field);
        }
        return new RowRecord(timestamp, fields);
    }

    public void close() throws Exception {
        this.tablet = null;
    }

    private int getColumnSize() {
        return this.tablet.getSchemas().size();
    }

    private void generateRowIterator() {
        long[] timestamps = this.tablet.getTimestamps();
        TreeMap<Long, Integer> timestampToRowIndex = new TreeMap<Long, Integer>();
        int rowSize = timestamps.length;
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            Long timestamp = timestamps[rowIndex];
            timestampToRowIndex.put(timestamp, rowIndex);
        }
        this.rowIterator = timestampToRowIndex.entrySet().iterator();
    }

    private static Field generateFieldFromTabletValue(TSDataType dataType, Object value, int index) {
        Field field = new Field(dataType);
        switch (dataType) {
            case BOOLEAN: {
                boolean booleanValue = ((boolean[])value)[index];
                field.setBoolV(booleanValue);
                break;
            }
            case INT32: {
                int intValue = ((int[])value)[index];
                field.setIntV(intValue);
                break;
            }
            case DATE: {
                LocalDate dateValue = ((LocalDate[])value)[index];
                field.setIntV(DateUtils.parseDateExpressionToInt((LocalDate)dateValue).intValue());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long longValue = ((long[])value)[index];
                field.setLongV(longValue);
                break;
            }
            case FLOAT: {
                float floatValue = ((float[])value)[index];
                field.setFloatV(floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = ((double[])value)[index];
                field.setDoubleV(doubleValue);
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                Binary binaryValue = new Binary(((Binary[])value)[index].getValues());
                field.setBinaryV(binaryValue);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
        return field;
    }

    @TableModel
    public static enum ColumnCategory {
        TIME,
        TAG,
        FIELD,
        ATTRIBUTE;

    }
}

