/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class KillQueryStatement
extends Statement
implements IConfigStatement {
    private final String queryId;

    public KillQueryStatement(String queryId) {
        this.queryId = queryId;
    }

    public KillQueryStatement() {
        this.queryId = null;
    }

    public boolean isKillAll() {
        return this.queryId == null;
    }

    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitKillQuery(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

