/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IBatchReader;
import org.apache.tsfile.read.reader.IChunkReader;

public abstract class AbstractFileSeriesReader
implements IBatchReader {
    protected IChunkLoader chunkLoader;
    protected List<IChunkMetadata> chunkMetadataList;
    protected IChunkReader chunkReader;
    protected List<String> currentChunkMeasurementNames = new ArrayList<String>();
    private int chunkToRead;
    protected Filter filter;

    protected AbstractFileSeriesReader(IChunkLoader chunkLoader, List<IChunkMetadata> chunkMetadataList, Filter filter) {
        this.chunkLoader = chunkLoader;
        this.chunkMetadataList = chunkMetadataList;
        this.filter = filter;
        this.chunkToRead = 0;
    }

    @Override
    public boolean hasNextBatch() throws IOException {
        if (this.chunkReader != null && this.chunkReader.hasNextSatisfiedPage()) {
            return true;
        }
        while (this.chunkToRead < this.chunkMetadataList.size()) {
            IChunkMetadata chunkMetaData = this.nextChunkMeta();
            if (this.chunkCanSkip(chunkMetaData)) continue;
            this.initChunkReader(chunkMetaData);
            if (!this.chunkReader.hasNextSatisfiedPage()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BatchData nextBatch() throws IOException {
        return this.chunkReader.nextPageData();
    }

    protected abstract void initChunkReader(IChunkMetadata var1) throws IOException;

    protected abstract boolean chunkCanSkip(IChunkMetadata var1);

    @Override
    public void close() throws IOException {
        this.chunkLoader.close();
    }

    private IChunkMetadata nextChunkMeta() {
        return this.chunkMetadataList.get(this.chunkToRead++);
    }
}

