/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PrefixPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.UnionIoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.UnionPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.WithExclusionIoTDBPipePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.WithExclusionPipePattern;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePattern.class);

    public abstract String getPattern();

    public abstract boolean isRoot();

    public abstract boolean isLegal();

    public abstract boolean coversDb(String var1);

    public abstract boolean coversDevice(String var1);

    public abstract boolean mayOverlapWithDb(String var1);

    public abstract boolean mayOverlapWithDevice(String var1);

    public abstract boolean matchesMeasurement(String var1, String var2);

    public abstract List<PartialPath> getBaseInclusionPaths();

    public static <T> List<T> applyIndexesOnList(int[] filteredIndexes, List<T> originalList) {
        return Objects.nonNull(originalList) ? Arrays.stream(filteredIndexes).mapToObj(originalList::get).collect(Collectors.toList()) : null;
    }

    public static PipePattern parsePipePatternFromSourceParameters(PipeParameters sourceParameters) {
        PipePattern defaultInclusionPattern = PipePattern.buildUnionPattern(Collections.singletonList(new IoTDBPipePattern(null)));
        PipePattern inclusionPattern = PipePattern.parsePatternUnion(sourceParameters, "extractor.path", "source.path", "extractor.pattern", "source.pattern", defaultInclusionPattern);
        PipePattern exclusionPattern = PipePattern.parsePatternUnion(sourceParameters, "extractor.path.exclusion", "source.path.exclusion", "extractor.pattern.exclusion", "source.pattern.exclusion", null);
        if (exclusionPattern == null) {
            return inclusionPattern;
        }
        if (inclusionPattern instanceof IoTDBPipePatternOperations && exclusionPattern instanceof IoTDBPipePatternOperations) {
            return new WithExclusionIoTDBPipePattern((IoTDBPipePatternOperations)inclusionPattern, (IoTDBPipePatternOperations)exclusionPattern);
        }
        return new WithExclusionPipePattern(inclusionPattern, exclusionPattern);
    }

    public static PipePattern parsePatternFromString(String patternString, Function<String, PipePattern> basePatternSupplier) {
        String trimmedPattern;
        String string = trimmedPattern = patternString == null ? "" : patternString.trim();
        if (trimmedPattern.isEmpty()) {
            return basePatternSupplier.apply("");
        }
        if (trimmedPattern.startsWith("INCLUSION(") && trimmedPattern.endsWith(")")) {
            int inclusionEndIndex = PipePattern.findMatchingParenthesis(trimmedPattern, "INCLUSION(".length() - 1);
            if (inclusionEndIndex == -1) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
            String remaining = trimmedPattern.substring(inclusionEndIndex + 1).trim();
            if (!remaining.startsWith(", EXCLUSION(")) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
            try {
                String inclusionSubstring = trimmedPattern.substring("INCLUSION(".length(), inclusionEndIndex);
                String exclusionSubstring = trimmedPattern.substring(inclusionEndIndex + ", EXCLUSION(".length() + 1, trimmedPattern.length() - 1);
                PipePattern inclusionPattern = PipePattern.parsePatternFromString(inclusionSubstring, basePatternSupplier);
                PipePattern exclusionPattern = PipePattern.parsePatternFromString(exclusionSubstring, basePatternSupplier);
                if (inclusionPattern instanceof IoTDBPipePatternOperations && exclusionPattern instanceof IoTDBPipePatternOperations) {
                    return new WithExclusionIoTDBPipePattern((IoTDBPipePatternOperations)inclusionPattern, (IoTDBPipePatternOperations)exclusionPattern);
                }
                return new WithExclusionPipePattern(inclusionPattern, exclusionPattern);
            }
            catch (Exception e) {
                return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
            }
        }
        return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(trimmedPattern, basePatternSupplier));
    }

    private static PipePattern parsePatternUnion(PipeParameters sourceParameters, String extractorPathKey, String sourcePathKey, String extractorPatternKey, String sourcePatternKey, PipePattern defaultPattern) {
        String path = sourceParameters.getStringByKeys(new String[]{extractorPathKey, sourcePathKey});
        String pattern = sourceParameters.getStringByKeys(new String[]{extractorPatternKey, sourcePatternKey});
        if (path != null && pattern != null) {
            ArrayList<PipePattern> result = new ArrayList<PipePattern>();
            result.addAll(PipePattern.parseMultiplePatterns(path, IoTDBPipePattern::new));
            result.addAll(PipePattern.parsePatternsFromPatternParameter(pattern, sourceParameters));
            return PipePattern.buildUnionPattern(result);
        }
        if (path != null) {
            return PipePattern.buildUnionPattern(PipePattern.parseMultiplePatterns(path, IoTDBPipePattern::new));
        }
        if (pattern != null) {
            return PipePattern.buildUnionPattern(PipePattern.parsePatternsFromPatternParameter(pattern, sourceParameters));
        }
        return defaultPattern;
    }

    private static List<PipePattern> parsePatternsFromPatternParameter(String pattern, PipeParameters sourceParameters) {
        String patternFormat = sourceParameters.getStringByKeys(new String[]{"extractor.pattern.format", "source.pattern.format"});
        if (patternFormat == null) {
            return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
        }
        switch (patternFormat.toLowerCase()) {
            case "iotdb": {
                return PipePattern.parseMultiplePatterns(pattern, IoTDBPipePattern::new);
            }
            case "prefix": {
                return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
            }
        }
        LOGGER.info("Unknown pattern format: {}, use prefix matching format by default.", (Object)patternFormat);
        return PipePattern.parseMultiplePatterns(pattern, PrefixPipePattern::new);
    }

    private static List<PipePattern> parseMultiplePatterns(String pattern, Function<String, PipePattern> patternSupplier) {
        if (pattern.isEmpty()) {
            return Collections.singletonList(patternSupplier.apply(pattern));
        }
        ArrayList<PipePattern> patterns = new ArrayList<PipePattern>();
        StringBuilder currentPattern = new StringBuilder();
        boolean inBackticks = false;
        for (char c : pattern.toCharArray()) {
            if (c == '`') {
                inBackticks = !inBackticks;
                currentPattern.append(c);
                continue;
            }
            if (c == ',' && !inBackticks) {
                String singlePattern = currentPattern.toString().trim();
                if (!singlePattern.isEmpty()) {
                    patterns.add(patternSupplier.apply(singlePattern));
                }
                currentPattern.setLength(0);
                continue;
            }
            currentPattern.append(c);
        }
        String lastPattern = currentPattern.toString().trim();
        if (!lastPattern.isEmpty()) {
            patterns.add(patternSupplier.apply(lastPattern));
        }
        return patterns;
    }

    private static PipePattern buildUnionPattern(List<PipePattern> patterns) {
        boolean allIoTDB = true;
        for (PipePattern p : patterns) {
            if (p instanceof IoTDBPipePattern) continue;
            allIoTDB = false;
            break;
        }
        if (allIoTDB) {
            ArrayList<IoTDBPipePattern> iotdbPatterns = new ArrayList<IoTDBPipePattern>(patterns.size());
            for (PipePattern p : patterns) {
                iotdbPatterns.add((IoTDBPipePattern)p);
            }
            return new UnionIoTDBPipePattern(iotdbPatterns);
        }
        return new UnionPipePattern(patterns);
    }

    private static int findMatchingParenthesis(String text, int openParenIndex) {
        int depth = 1;
        boolean inBackticks = false;
        for (int i = openParenIndex + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '`') {
                inBackticks = !inBackticks;
                continue;
            }
            if (c == '(' && !inBackticks) {
                ++depth;
                continue;
            }
            if (c != ')' || inBackticks || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    public static int[] checkAndLogPatternCoverage(PipePattern inclusion, PipePattern exclusion) throws PipeException {
        List<PartialPath> inclusionPaths;
        if (inclusion == null || exclusion == null) {
            return new int[]{0, 0};
        }
        int coveredCount = 0;
        try {
            inclusionPaths = inclusion.getBaseInclusionPaths();
            List<PartialPath> exclusionPaths = exclusion.getBaseInclusionPaths();
            if (inclusionPaths.isEmpty() || exclusionPaths.isEmpty()) {
                return new int[]{0, inclusionPaths.size()};
            }
            for (PartialPath incPath : inclusionPaths) {
                boolean isCovered = exclusionPaths.stream().anyMatch(excPath -> excPath.include(incPath));
                if (!isCovered) continue;
                ++coveredCount;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Pipe: Failed to perform pattern coverage check for inclusion [{}] and exclusion [{}].", new Object[]{inclusion.getPattern(), exclusion.getPattern(), e});
            return new int[]{-1, -1};
        }
        if (coveredCount == inclusionPaths.size() && !inclusionPaths.isEmpty()) {
            String msg = String.format("Pipe: The provided exclusion pattern fully covers the inclusion pattern. This pipe pattern will match nothing. Inclusion: [%s], Exclusion: [%s]", inclusion.getPattern(), exclusion.getPattern());
            LOGGER.warn(msg);
            throw new PipeException(msg);
        }
        if (coveredCount > 0) {
            LOGGER.warn("Pipe: The provided exclusion pattern covers {} out of {} inclusion paths. These paths will be excluded. Inclusion: [{}], Exclusion: [{}]", new Object[]{coveredCount, inclusionPaths.size(), inclusion.getPattern(), exclusion.getPattern()});
        }
        return new int[]{coveredCount, inclusionPaths.size()};
    }
}

