/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.utils.datastructure.QuickSort;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.enums.TSDataType;

public class BackwardSort
extends QuickSort {
    public static double INVERSION_RATIOS_THRESHOLD = 0.004;
    private final List<long[]> tmpTimestamps = new ArrayList<long[]>();
    private final List<int[]> tmpIndices = new ArrayList<int[]>();
    private int tmpLength = 0;

    public BackwardSort(TVList tvList) {
        super(tvList);
    }

    public void setFromTmp(int src, int dest) {
        this.tvList.set(dest, this.tmpTimestamps.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE], this.tmpIndices.get(src / PrimitiveArrayManager.ARRAY_SIZE)[src % PrimitiveArrayManager.ARRAY_SIZE]);
    }

    public void setToTmp(int src, int dest) {
        this.tmpTimestamps.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.tvList.getTime(src);
        this.tmpIndices.get((int)(dest / PrimitiveArrayManager.ARRAY_SIZE))[dest % PrimitiveArrayManager.ARRAY_SIZE] = this.tvList.getValueIndex(src);
    }

    public void backward_set(int src, int dest) {
        this.tvList.set(src, dest);
    }

    public int compareTmp(int idx, int tmpIdx) {
        long t1 = this.tvList.getTime(idx);
        long t2 = this.tmpTimestamps.get(tmpIdx / PrimitiveArrayManager.ARRAY_SIZE)[tmpIdx % PrimitiveArrayManager.ARRAY_SIZE];
        return Long.compare(t1, t2);
    }

    public void checkTmpLength(int len) {
        while (len > this.tmpLength) {
            this.tmpTimestamps.add((long[])this.tvList.getPrimitiveArraysByType(TSDataType.INT64));
            this.tmpIndices.add((int[])this.tvList.getPrimitiveArraysByType(TSDataType.INT32));
            this.tmpLength += PrimitiveArrayManager.ARRAY_SIZE;
        }
    }

    public void clearTmp() {
        for (Object[] dataArray : this.tmpTimestamps) {
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpTimestamps.clear();
        Iterator<long[]> iterator = this.tmpIndices.iterator();
        while (iterator.hasNext()) {
            Object[] dataArray;
            dataArray = (int[])iterator.next();
            PrimitiveArrayManager.release(dataArray);
        }
        this.tmpIndices.clear();
        this.tmpLength = 0;
    }

    public void backwardSort(List<long[]> timestamps, int rowCount) {
        int block_size = this.setBlockLength(timestamps, 1);
        int B = rowCount / block_size + 1;
        this.sortBlock((B - 1) * block_size, rowCount - 1);
        for (int i = B - 2; i >= 0; --i) {
            int lo = i * block_size;
            int hi = lo + block_size - 1;
            this.sortBlock(lo, hi);
            this.backwardMergeBlocks(lo, hi, rowCount);
        }
    }

    public int setBlockLength(List<long[]> timestamps, int step) {
        double overlap = 0.0;
        long last_time = timestamps.get(0)[0];
        int i = step;
        int blocks = 0;
        while (i < timestamps.size()) {
            long cur_time = timestamps.get(i)[0];
            if (last_time > cur_time) {
                overlap += 1.0;
            }
            last_time = cur_time;
            i += step;
            ++blocks;
        }
        double ratio = overlap / (double)blocks;
        int mul = (int)Math.ceil(ratio / INVERSION_RATIOS_THRESHOLD);
        if (mul <= 1) {
            return step * PrimitiveArrayManager.ARRAY_SIZE;
        }
        return this.setBlockLength(timestamps, mul * step);
    }

    public void backwardMergeBlocks(int lo, int hi, int rowCount) {
        int overlapIdx;
        for (overlapIdx = hi + 1; overlapIdx < rowCount && this.compare(hi, overlapIdx) == 1; ++overlapIdx) {
        }
        if (overlapIdx == hi + 1) {
            return;
        }
        int tmpIdx = 0;
        int len = overlapIdx - hi;
        this.checkTmpLength(len);
        for (int i = hi + 1; i < overlapIdx; ++i) {
            this.setToTmp(i, tmpIdx);
            ++tmpIdx;
        }
        int a = hi;
        int b = tmpIdx - 1;
        int idx = overlapIdx - 1;
        while (a >= lo && b >= 0) {
            if (this.compareTmp(a, b) == 1) {
                this.backward_set(a, idx);
                --a;
            } else {
                this.setFromTmp(b, idx);
                --b;
            }
            --idx;
        }
        while (b >= 0) {
            this.setFromTmp(b, idx);
            --b;
            --idx;
        }
    }

    public void sortBlock(int lo, int hi) {
        this.qsort(lo, hi);
    }
}

