/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.key;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisExpireCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.EXPIRE, GridRedisCommand.PEXPIRE);
    private static final int TTL_POS = 2;

    public GridRedisExpireCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd, ctx);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        if (msg.messageSize() < 2) {
            throw new GridRedisGenericException("Wrong number of arguments (key is missing)");
        }
        if (msg.messageSize() < 3) {
            throw new GridRedisGenericException("Wrong number of arguments (timeout value is missing)");
        }
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.clientId(msg.clientId());
        restReq.key(msg.key());
        restReq.command(GridRestCommand.CACHE_UPDATE_TLL);
        restReq.cacheName(msg.cacheName());
        switch (msg.command()) {
            case EXPIRE: {
                restReq.ttl(Long.valueOf(msg.aux(2)) * 1000L);
                break;
            }
            default: {
                restReq.ttl(Long.valueOf(msg.aux(2)));
            }
        }
        return restReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        return (Boolean)restRes.getResponse() != false ? GridRedisProtocolParser.toInteger("1") : GridRedisProtocolParser.toInteger("0");
    }
}

