/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import org.apache.ignite.internal.metrics.AtomicDoubleMetric;
import org.apache.ignite.internal.metrics.AtomicIntMetric;
import org.apache.ignite.internal.metrics.AtomicLongMetric;
import org.apache.ignite.internal.metrics.DistributionMetric;
import org.apache.ignite.internal.metrics.DoubleAdderMetric;
import org.apache.ignite.internal.metrics.DoubleGauge;
import org.apache.ignite.internal.metrics.HitRateMetric;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.LongAdderMetric;
import org.apache.ignite.internal.metrics.LongGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.MetricSet;
import org.jetbrains.annotations.Nullable;

public class MetricSetBuilder {
    private final String name;
    private Map<String, Metric> metrics = new LinkedHashMap<String, Metric>();

    public MetricSetBuilder(String name) {
        Objects.requireNonNull(name, "Metrics set name can't be null");
        this.name = name;
    }

    public MetricSet build() {
        if (this.metrics == null) {
            throw new IllegalStateException("Builder can't be used twice.");
        }
        MetricSet reg = new MetricSet(this.name, this.metrics);
        this.metrics = null;
        return reg;
    }

    public String name() {
        return this.name;
    }

    public <T extends Metric> T register(T metric) {
        Metric old = this.metrics.putIfAbsent(metric.name(), metric);
        if (old != null) {
            throw new IllegalStateException("Metric with given name is already registered [name=" + this.name + ", metric=" + String.valueOf(metric) + "]");
        }
        return metric;
    }

    public AtomicIntMetric atomicInt(String name, @Nullable String description) {
        return this.register(new AtomicIntMetric(name, description));
    }

    public IntGauge intGauge(String name, @Nullable String description, IntSupplier supplier) {
        return this.register(new IntGauge(name, description, supplier));
    }

    public AtomicLongMetric atomicLong(String name, @Nullable String description) {
        return this.register(new AtomicLongMetric(name, description));
    }

    public LongAdderMetric longAdder(String name, @Nullable String description) {
        return this.register(new LongAdderMetric(name, description));
    }

    public LongGauge longGauge(String name, @Nullable String description, LongSupplier supplier) {
        return this.register(new LongGauge(name, description, supplier));
    }

    public AtomicDoubleMetric atomicDouble(String name, @Nullable String description) {
        return this.register(new AtomicDoubleMetric(name, description));
    }

    public DoubleAdderMetric doubleAdder(String name, @Nullable String description) {
        return this.register(new DoubleAdderMetric(name, description));
    }

    public DoubleGauge doubleGauge(String name, @Nullable String description, DoubleSupplier supplier) {
        return this.register(new DoubleGauge(name, description, supplier));
    }

    public HitRateMetric hitRate(String name, @Nullable String description, long rateTimeInterval) {
        return this.register(new HitRateMetric(name, description, rateTimeInterval));
    }

    public HitRateMetric hitRate(String name, @Nullable String description, long rateTimeInterval, int size) {
        return this.register(new HitRateMetric(name, description, rateTimeInterval, size));
    }

    public DistributionMetric distribution(String name, @Nullable String description, long[] bounds) {
        return this.register(new DistributionMetric(name, description, bounds));
    }
}

