/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package grails.gorm.rx.collection;

import java.io.Serializable;
import java.util.List;

/**
 * Implemented by collections that store the inverse association keys to perform a lookup
 *
 * @author Graeme
 * @since 6.0
 */
public interface RxUnidirectionalCollection {
    /**
     * @return The association keys in the case of unidirectional one-to-many
     */
    List<Serializable> getAssociationKeys();

}
