/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class TelephoneNumberSyntaxChecker
extends SyntaxChecker {
    private static final String DEFAULT_REGEXP = "^ *[+]? *((\\([0-9- ,;/#*]+\\))|[0-9- ,;/#*]+)+$";
    private final String defaultRegexp;
    private final Pattern defaultPattern;
    public static final TelephoneNumberSyntaxChecker INSTANCE = new TelephoneNumberSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.50");

    private TelephoneNumberSyntaxChecker(String oid) {
        this(oid, DEFAULT_REGEXP, Pattern.compile(DEFAULT_REGEXP));
    }

    private TelephoneNumberSyntaxChecker(String oid, String defaultRegexp, Pattern defaultPattern) {
        super(oid);
        this.defaultPattern = defaultPattern;
        this.defaultRegexp = defaultRegexp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRegexp() {
        return this.defaultRegexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidSyntax(Object value) {
        boolean result;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        if (strValue.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
            return false;
        }
        Pattern pattern = this.defaultPattern;
        synchronized (pattern) {
            result = this.defaultPattern.matcher(strValue).matches();
        }
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_04489_SYNTAX_VALID, (Object[])new Object[]{value}));
            } else {
                LOG.debug(I18n.err((I18n)I18n.ERR_04488_SYNTAX_INVALID, (Object[])new Object[]{value}));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<TelephoneNumberSyntaxChecker> {
        private String defaultRegexp;
        private Pattern defaultPattern;

        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.50");
            this.setDefaultRegexp(TelephoneNumberSyntaxChecker.DEFAULT_REGEXP);
        }

        @Override
        public TelephoneNumberSyntaxChecker build() {
            return new TelephoneNumberSyntaxChecker(this.oid, this.defaultRegexp, this.defaultPattern);
        }

        public Builder setDefaultRegexp(String regexp) {
            this.defaultRegexp = regexp;
            try {
                this.defaultPattern = Pattern.compile(regexp);
            }
            catch (PatternSyntaxException pse) {
                this.defaultPattern = Pattern.compile(TelephoneNumberSyntaxChecker.DEFAULT_REGEXP);
            }
            return this;
        }
    }
}

