/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.common.QuickSelect;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Util;

public class TupleUnion<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> qsk_;
    private long unionThetaLong_;
    private boolean empty_;

    public TupleUnion(SummarySetOperations<S> summarySetOps) {
        this(4096, summarySetOps);
    }

    public TupleUnion(int nomEntries, SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.qsk_ = new QuickSelectSketch(nomEntries, null);
        this.unionThetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }

    public CompactTupleSketch<S> union(TupleSketch<S> tupleSketchA, TupleSketch<S> tupleSketchB) {
        this.reset();
        this.union(tupleSketchA);
        this.union(tupleSketchB);
        CompactTupleSketch<S> csk = this.getResult(true);
        return csk;
    }

    public CompactTupleSketch<S> union(TupleSketch<S> tupleSketch, ThetaSketch thetaSketch, S summary) {
        this.reset();
        this.union(tupleSketch);
        this.union(thetaSketch, summary);
        CompactTupleSketch<S> csk = this.getResult(true);
        return csk;
    }

    public void union(TupleSketch<S> tupleSketch) {
        if (tupleSketch == null || tupleSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        this.unionThetaLong_ = Math.min(tupleSketch.thetaLong_, this.unionThetaLong_);
        TupleSketchIterator<S> it = tupleSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.getHash(), it.getSummary(), this.summarySetOps_);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
    }

    public void union(ThetaSketch thetaSketch, S summary) {
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        if (thetaSketch == null || thetaSketch.isEmpty()) {
            return;
        }
        this.empty_ = false;
        long thetaIn = thetaSketch.getThetaLong();
        this.unionThetaLong_ = Math.min(thetaIn, this.unionThetaLong_);
        HashIterator it = thetaSketch.iterator();
        while (it.next()) {
            this.qsk_.merge(it.get(), summary, this.summarySetOps_);
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
    }

    public CompactTupleSketch<S> getResult() {
        return this.getResult(false);
    }

    public CompactTupleSketch<S> getResult(boolean reset) {
        CompactTupleSketch result;
        if (this.empty_) {
            result = this.qsk_.compact();
        } else if (this.unionThetaLong_ >= this.qsk_.thetaLong_ && this.qsk_.getRetainedEntries() <= this.qsk_.getNominalEntries()) {
            result = this.qsk_.compact();
        } else {
            long tmpThetaLong = Math.min(this.unionThetaLong_, this.qsk_.thetaLong_);
            int numHashesIn = 0;
            TupleSketchIterator<S> it = this.qsk_.iterator();
            while (it.next()) {
                if (it.getHash() >= tmpThetaLong) continue;
                ++numHashesIn;
            }
            if (numHashesIn == 0) {
                result = new CompactTupleSketch(null, null, tmpThetaLong, this.empty_);
            } else {
                long thetaLongOut;
                int numHashesOut;
                if (numHashesIn > this.qsk_.getNominalEntries()) {
                    long[] tmpHashArr = new long[numHashesIn];
                    it = this.qsk_.iterator();
                    int i = 0;
                    while (it.next()) {
                        long hash = it.getHash();
                        if (hash >= tmpThetaLong) continue;
                        tmpHashArr[i++] = hash;
                    }
                    numHashesOut = this.qsk_.getNominalEntries();
                    thetaLongOut = QuickSelect.select(tmpHashArr, 0, numHashesIn - 1, numHashesOut);
                } else {
                    numHashesOut = numHashesIn;
                    thetaLongOut = tmpThetaLong;
                }
                long[] hashArr = new long[numHashesOut];
                Summary[] summaries = Util.newSummaryArray((Summary[])this.qsk_.getSummaryTable(), (int)numHashesOut);
                it = this.qsk_.iterator();
                int i = 0;
                while (it.next()) {
                    long hash = it.getHash();
                    if (hash >= thetaLongOut) continue;
                    hashArr[i] = hash;
                    summaries[i] = it.getSummary().copy();
                    ++i;
                }
                result = new CompactTupleSketch(hashArr, summaries, thetaLongOut, this.empty_);
            }
        }
        if (reset) {
            this.reset();
        }
        return result;
    }

    public void reset() {
        this.qsk_.reset();
        this.unionThetaLong_ = this.qsk_.getThetaLong();
        this.empty_ = true;
    }
}

