/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;

public final class QuantilesItemsUnion<T> {
    final int maxK_;
    final Comparator<? super T> comparator_;
    QuantilesItemsSketch<T> gadget_;
    Class<T> clazz_;

    private QuantilesItemsUnion(int maxK, Comparator<? super T> comparator, QuantilesItemsSketch<T> gadget) {
        Objects.requireNonNull(gadget, "Gadget sketch must not be null.");
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        this.maxK_ = maxK;
        this.comparator_ = comparator;
        this.gadget_ = gadget;
        this.clazz_ = gadget.clazz;
        this.gadget_.classicQisSV = null;
    }

    public static <T> QuantilesItemsUnion<T> getInstance(Class<T> clazz, Comparator<? super T> comparator) {
        QuantilesItemsSketch<? super T> emptySk = QuantilesItemsSketch.getInstance(clazz, comparator);
        return new QuantilesItemsUnion<T>(128, comparator, emptySk);
    }

    public static <T> QuantilesItemsUnion<T> getInstance(Class<T> clazz, int maxK, Comparator<? super T> comparator) {
        QuantilesItemsSketch<? super T> emptySk = QuantilesItemsSketch.getInstance(clazz, maxK, comparator);
        return new QuantilesItemsUnion<T>(maxK, comparator, emptySk);
    }

    public static <T> QuantilesItemsUnion<T> initializeWithMemorySegment(Class<T> clazz, MemorySegment srcSeg, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        QuantilesItemsSketch<T> gadget = QuantilesItemsSketch.heapify(clazz, srcSeg, comparator, serDe);
        return new QuantilesItemsUnion<T>(gadget.getK(), gadget.getComparator(), gadget);
    }

    public static <T> QuantilesItemsUnion<T> initialize(QuantilesItemsSketch<T> sketch) {
        return new QuantilesItemsUnion<T>(sketch.getK(), sketch.getComparator(), QuantilesItemsSketch.copy(sketch));
    }

    public void union(QuantilesItemsSketch<T> sketchIn) {
        this.gadget_ = QuantilesItemsUnion.updateLogic(this.maxK_, this.comparator_, this.gadget_, sketchIn);
    }

    public void union(MemorySegment srcSeg, ArrayOfItemsSerDe<T> serDe) {
        QuantilesItemsSketch<? super T> that = QuantilesItemsSketch.heapify(this.clazz_, srcSeg, this.comparator_, serDe);
        this.gadget_ = QuantilesItemsUnion.updateLogic(this.maxK_, this.comparator_, this.gadget_, that);
    }

    public void update(T dataItem) {
        if (dataItem == null) {
            return;
        }
        if (this.gadget_ == null) {
            this.gadget_ = QuantilesItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
        }
        this.gadget_.update(dataItem);
    }

    public QuantilesItemsSketch<T> getResult() {
        if (this.gadget_ == null) {
            return QuantilesItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
        }
        return QuantilesItemsSketch.copy(this.gadget_);
    }

    public QuantilesItemsSketch<T> getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        return this.gadget_.getSketchAndReset();
    }

    public void reset() {
        this.gadget_ = null;
    }

    public boolean isEmpty() {
        return this.gadget_ == null || this.gadget_.isEmpty();
    }

    public int getMaxK() {
        return this.maxK_;
    }

    public int getEffectiveK() {
        return this.gadget_ != null ? this.gadget_.getK() : this.maxK_;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        int maxK = this.getMaxK();
        String kStr = String.format("%,d", maxK);
        sb.append(Util.LS).append("### Quantiles ").append(thisSimpleName).append(Util.LS);
        sb.append("   maxK                         : ").append(kStr);
        if (this.gadget_ == null) {
            sb.append(QuantilesItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_).toString());
            return sb.toString();
        }
        sb.append(this.gadget_.toString(sketchSummary, dataDetail));
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        if (this.gadget_ == null) {
            QuantilesItemsSketch<T> sketch = QuantilesItemsSketch.getInstance(this.clazz_, this.maxK_, this.comparator_);
            return sketch.toByteArray(serDe);
        }
        return this.gadget_.toByteArray(serDe);
    }

    static <T> QuantilesItemsSketch<T> updateLogic(int myMaxK, Comparator<? super T> comparator, QuantilesItemsSketch<T> myQS, QuantilesItemsSketch<T> other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
                break;
            }
        }
        QuantilesItemsSketch<Object> ret = null;
        switch (outCase) {
            case 0: {
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                assert (other != null);
                if (!other.isEstimationMode()) {
                    ret = QuantilesItemsSketch.getInstance(other.getClassOfT(), myMaxK, comparator);
                    int otherCnt = other.getBaseBufferCount();
                    Object[] combBuf = other.getCombinedBuffer();
                    for (int i = 0; i < otherCnt; ++i) {
                        ret.update(combBuf[i]);
                    }
                    break;
                }
                ret = myMaxK < other.getK() ? other.downSample(myMaxK) : QuantilesItemsSketch.copy(other);
                break;
            }
            case 3: {
                assert (other != null);
                assert (myQS != null);
                if (!other.isEstimationMode()) {
                    ret = myQS;
                    int otherCnt = other.getBaseBufferCount();
                    Object[] combBuf = other.getCombinedBuffer();
                    for (int i = 0; i < otherCnt; ++i) {
                        ret.update(combBuf[i]);
                    }
                    break;
                }
                if (myQS.getK() <= other.getK()) {
                    ItemsMergeImpl.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                ret = QuantilesItemsSketch.copy(other);
                ItemsMergeImpl.mergeInto(myQS, ret);
                break;
            }
            case 4: {
                assert (other != null);
                ret = QuantilesItemsSketch.getInstance(other.getClassOfT(), Math.min(myMaxK, other.getK()), comparator);
                break;
            }
        }
        return ret;
    }
}

