/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ClassicUtil;

final class PreambleUtil {
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SER_VER_BYTE = 1;
    static final int FAMILY_BYTE = 2;
    static final int FLAGS_BYTE = 3;
    static final int K_SHORT = 4;
    static final int N_LONG = 8;
    static final int MIN_DOUBLE = 16;
    static final int MAX_DOUBLE = 24;
    static final int COMBINED_BUFFER = 32;
    static final int RESERVED_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int ORDERED_FLAG_MASK = 16;
    static final int DEFAULT_K = 128;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr, boolean isDoublesSketch) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return PreambleUtil.toString(seg, isDoublesSketch);
    }

    static String toString(MemorySegment seg, boolean isDoublesSketch) {
        return PreambleUtil.memorySegmentToString(seg, isDoublesSketch);
    }

    private static String memorySegmentToString(MemorySegment srcSeg, boolean isDoublesSketch) {
        int preLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        String famName = Family.idToFamily(familyID).toString();
        int flags = PreambleUtil.extractFlags(srcSeg);
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean compact = (flags & 8) > 0;
        boolean ordered = (flags & 0x10) > 0;
        int k = PreambleUtil.extractK(srcSeg);
        long n = preLongs == 1 ? 0L : PreambleUtil.extractN(srcSeg);
        double minDouble = Double.NaN;
        double maxDouble = Double.NaN;
        if (preLongs > 1 && isDoublesSketch) {
            minDouble = PreambleUtil.extractMinDouble(srcSeg);
            maxDouble = PreambleUtil.extractMaxDouble(srcSeg);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### QUANTILES SKETCH PREAMBLE SUMMARY:").append(Util.LS);
        sb.append("Byte  0: Preamble Longs       : ").append(preLongs).append(Util.LS);
        sb.append("Byte  1: Serialization Version: ").append(serVer).append(Util.LS);
        sb.append("Byte  2: Family               : ").append(famName).append(Util.LS);
        sb.append("Byte  3: Flags Field          : ").append(String.format("%02o", flags)).append(Util.LS);
        sb.append("  RESERVED                    : ").append(Util.LS);
        sb.append("  READ ONLY                   : ").append(readOnly).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("  COMPACT                     : ").append(compact).append(Util.LS);
        sb.append("  ORDERED                     : ").append(ordered).append(Util.LS);
        sb.append("Bytes  4-5  : K               : ").append(k).append(Util.LS);
        if (preLongs == 1) {
            sb.append(" --ABSENT, ASSUMED:").append(Util.LS);
        }
        sb.append("Bytes  8-15 : N                : ").append(n).append(Util.LS);
        if (isDoublesSketch) {
            sb.append("MinDouble                      : ").append(minDouble).append(Util.LS);
            sb.append("MaxDouble                      : ").append(maxDouble).append(Util.LS);
        }
        sb.append("Retained Items                 : ").append(ClassicUtil.computeRetainedItems(k, n)).append(Util.LS);
        sb.append("Total Bytes                    : ").append(srcSeg.byteSize()).append(Util.LS);
        sb.append("### END SKETCH PREAMBLE SUMMARY").append(Util.LS);
        return sb.toString();
    }

    static int extractPreLongs(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 0L) & 0xFF;
    }

    static int extractSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 1L) & 0xFF;
    }

    static int extractFamilyID(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 2L) & 0xFF;
    }

    static int extractFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, 3L) & 0xFF;
    }

    static int extractK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 4L) & 0xFFFF;
    }

    static long extractN(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    static double extractMinDouble(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
    }

    static double extractMaxDouble(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
    }

    static void insertPreLongs(MemorySegment wseg, int numPreLongs) {
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)numPreLongs);
    }

    static void insertSerVer(MemorySegment wseg, int serVer) {
        wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)serVer);
    }

    static void insertFamilyID(MemorySegment wseg, int famId) {
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)famId);
    }

    static void insertFlags(MemorySegment wseg, int flags) {
        wseg.set(ValueLayout.JAVA_BYTE, 3L, (byte)flags);
    }

    static void insertK(MemorySegment wseg, int k) {
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 4L, (short)k);
    }

    static void insertN(MemorySegment wseg, long n) {
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, n);
    }

    static void insertMinDouble(MemorySegment wseg, double minDouble) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L, minDouble);
    }

    static void insertMaxDouble(MemorySegment wseg, double maxDouble) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L, maxDouble);
    }
}

