/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.group.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.group.impl.GroupHandlingAbstract;
import org.apache.activemq.artemis.core.server.group.impl.Proposal;
import org.apache.activemq.artemis.core.server.group.impl.Response;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.utils.ConcurrentUtil;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalGroupingHandler
extends GroupHandlingAbstract {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<SimpleString, GroupBinding> map = new ConcurrentHashMap<SimpleString, GroupBinding>();
    private final ConcurrentMap<SimpleString, List<GroupBinding>> groupMap = new ConcurrentHashMap<SimpleString, List<GroupBinding>>();
    private final SimpleString name;
    private final StorageManager storageManager;
    private final long timeout;
    private final Lock lock = new ReentrantLock();
    private final Condition awaitCondition = this.lock.newCondition();
    private List<SimpleString> expectedBindings = new LinkedList<SimpleString>();
    private final long groupTimeout;
    private boolean waitingForBindings = false;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean started;
    private ScheduledFuture reaperFuture;
    private final long reaperPeriod;

    public LocalGroupingHandler(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, ManagementService managementService, SimpleString name, SimpleString address, StorageManager storageManager, long timeout, long groupTimeout, long reaperPeriod) {
        super((Executor)executorFactory.getExecutor(), managementService, address);
        this.reaperPeriod = reaperPeriod;
        this.scheduledExecutor = scheduledExecutor;
        this.name = name;
        this.storageManager = storageManager;
        this.timeout = timeout;
        this.groupTimeout = groupTimeout;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response propose(Proposal proposal) throws Exception {
        OperationContext originalCtx = this.storageManager.getContext();
        try {
            this.storageManager.setContext(this.storageManager.newSingleThreadContext());
            if (proposal.getClusterName() == null) {
                GroupBinding original = (GroupBinding)this.map.get(proposal.getGroupId());
                if (original != null) {
                    original.use();
                    Response response = new Response(proposal.getGroupId(), original.getClusterName());
                    return response;
                }
                Response response = null;
                return response;
            }
            boolean addRecord = false;
            GroupBinding groupBinding = null;
            this.lock.lock();
            try {
                groupBinding = (GroupBinding)this.map.get(proposal.getGroupId());
                if (groupBinding != null) {
                    groupBinding.use();
                    Response response = new Response(groupBinding.getGroupId(), proposal.getClusterName(), groupBinding.getClusterName());
                    return response;
                }
                addRecord = true;
                groupBinding = new GroupBinding(proposal.getGroupId(), proposal.getClusterName());
                groupBinding.setId(this.storageManager.generateID());
                List<GroupBinding> newList = new ArrayList<GroupBinding>();
                List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
                if (oldList != null) {
                    newList = oldList;
                }
                newList.add(groupBinding);
                this.map.put(groupBinding.getGroupId(), groupBinding);
            }
            finally {
                this.lock.unlock();
            }
            if (addRecord) {
                this.storageManager.addGrouping(groupBinding);
            }
            Response response = new Response(groupBinding.getGroupId(), groupBinding.getClusterName());
            return response;
        }
        finally {
            this.storageManager.setContext(originalCtx);
        }
    }

    @Override
    public void resendPending() throws Exception {
    }

    @Override
    public void proposed(Response response) throws Exception {
    }

    @Override
    public void remove(SimpleString groupid, SimpleString clusterName, int distance) throws Exception {
        this.remove(groupid, clusterName);
    }

    @Override
    public void sendProposalResponse(Response response, int distance) throws Exception {
        TypedProperties props = new TypedProperties();
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_GROUP_ID, response.getGroupId());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_VALUE, response.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_PROPOSAL_ALT_VALUE, response.getAlternativeClusterName());
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, 0);
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.address);
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, distance);
        Notification notification = new Notification(null, (NotificationType)CoreNotificationType.PROPOSAL_RESPONSE, props);
        this.managementService.sendNotification(notification);
    }

    @Override
    public Response receive(Proposal proposal, int distance) throws Exception {
        logger.trace("received proposal {}", (Object)proposal);
        return this.propose(proposal);
    }

    @Override
    public void addGroupBinding(GroupBinding groupBinding) {
        this.map.put(groupBinding.getGroupId(), groupBinding);
        List<GroupBinding> newList = new ArrayList<GroupBinding>();
        List oldList = this.groupMap.putIfAbsent(groupBinding.getClusterName(), newList);
        if (oldList != null) {
            newList = oldList;
        }
        newList.add(groupBinding);
    }

    @Override
    public Response getProposal(SimpleString fullID, boolean touchTime) {
        GroupBinding original = (GroupBinding)this.map.get(fullID);
        if (original != null) {
            if (touchTime) {
                original.use();
            }
            return new Response(fullID, original.getClusterName());
        }
        return null;
    }

    @Override
    public void remove(SimpleString groupid, SimpleString clusterName) {
        GroupBinding groupBinding = (GroupBinding)this.map.remove(groupid);
        List groupBindings = (List)this.groupMap.get(clusterName);
        if (groupBindings != null && groupBinding != null) {
            groupBindings.remove(groupBinding);
            try {
                long tx = this.storageManager.generateID();
                this.storageManager.deleteGrouping(tx, groupBinding);
                this.storageManager.commitBindings(tx);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void awaitBindings() throws Exception {
        this.lock.lock();
        try {
            if (this.groupMap.size() > 0) {
                List bindingsAlreadyAdded;
                this.waitingForBindings = true;
                if (this.expectedBindings == null) {
                    bindingsAlreadyAdded = Collections.emptyList();
                    this.expectedBindings = new LinkedList<SimpleString>();
                } else {
                    bindingsAlreadyAdded = new ArrayList<SimpleString>(this.expectedBindings);
                    this.expectedBindings.clear();
                }
                this.expectedBindings.addAll(this.groupMap.keySet());
                this.expectedBindings.removeAll(bindingsAlreadyAdded);
                if (this.expectedBindings.size() > 0) {
                    logger.debug("Waiting remote group bindings to arrive before starting the server. timeout={} milliseconds", (Object)this.timeout);
                    if (!ConcurrentUtil.await((Condition)this.awaitCondition, (long)this.timeout)) {
                        ActiveMQServerLogger.LOGGER.remoteGroupCoordinatorsNotStarted();
                    }
                }
            }
        }
        finally {
            this.expectedBindings = null;
            this.waitingForBindings = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        if (notification.getType() == CoreNotificationType.BINDING_REMOVED) {
            SimpleString clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            this.removeGrouping(clusterName);
        } else if (notification.getType() == CoreNotificationType.BINDING_ADDED) {
            SimpleString clusterName = notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
            try {
                this.lock.lock();
                if (this.expectedBindings != null) {
                    if (this.waitingForBindings) {
                        if (this.expectedBindings.remove(clusterName)) {
                            logger.debug("OnNotification for waitForbindings::Removed clusterName={} from list succesffully", (Object)clusterName);
                        } else {
                            logger.debug("OnNotification for waitForbindings::Couldn't remove clusterName={} as it wasn't on the original list", (Object)clusterName);
                        }
                    } else {
                        this.expectedBindings.add(clusterName);
                        logger.debug("Notification for waitForbindings::Adding previously known item clusterName={}", (Object)clusterName);
                    }
                    if (logger.isDebugEnabled()) {
                        for (SimpleString stillWaiting : this.expectedBindings) {
                            logger.debug("Notification for waitForbindings::Still waiting for clusterName={}", (Object)stillWaiting);
                        }
                    }
                    if (this.expectedBindings.size() == 0) {
                        this.awaitCondition.signal();
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.lock.lock();
        try {
            if (this.expectedBindings == null) {
                this.expectedBindings = new LinkedList<SimpleString>();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.reaperPeriod > 0L && this.groupTimeout > 0L) {
            if (this.reaperFuture != null) {
                this.reaperFuture.cancel(true);
                this.reaperFuture = null;
            }
            this.reaperFuture = this.scheduledExecutor.scheduleAtFixedRate(new GroupReaperScheduler(), this.reaperPeriod, this.reaperPeriod, TimeUnit.MILLISECONDS);
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        if (this.reaperFuture != null) {
            this.reaperFuture.cancel(true);
            this.reaperFuture = null;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void removeGrouping(SimpleString clusterName) {
        List list = (List)this.groupMap.remove(clusterName);
        if (list != null) {
            this.executor.execute(() -> {
                long txID = -1L;
                for (GroupBinding val : list) {
                    if (val == null) continue;
                    this.fireUnproposed(val.getGroupId());
                    this.map.remove(val.getGroupId());
                    this.sendUnproposal(val.getGroupId(), clusterName, 0);
                    try {
                        if (txID < 0L) {
                            txID = this.storageManager.generateID();
                        }
                        this.storageManager.deleteGrouping(txID, val);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeleteGroupBindings(val.getGroupId(), e);
                    }
                }
                if (txID >= 0L) {
                    try {
                        this.storageManager.commitBindings(txID);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeleteGroupBindings(SimpleString.of((String)("TX:" + txID)), e);
                    }
                }
            });
        }
    }

    private final class GroupReaperScheduler
    implements Runnable {
        final GroupIdReaper reaper;

        private GroupReaperScheduler() {
            this.reaper = new GroupIdReaper();
        }

        @Override
        public void run() {
            LocalGroupingHandler.this.executor.execute(this.reaper);
        }
    }

    private final class GroupIdReaper
    implements Runnable {
        private GroupIdReaper() {
        }

        @Override
        public void run() {
            if (LocalGroupingHandler.this.isStarted()) {
                long txID = -1L;
                int expiredGroups = 0;
                for (GroupBinding groupBinding : LocalGroupingHandler.this.map.values()) {
                    if (groupBinding.getTimeUsed() + LocalGroupingHandler.this.groupTimeout >= System.currentTimeMillis()) continue;
                    LocalGroupingHandler.this.map.remove(groupBinding.getGroupId());
                    List groupBindings = (List)LocalGroupingHandler.this.groupMap.get(groupBinding.getClusterName());
                    groupBindings.remove(groupBinding);
                    LocalGroupingHandler.this.fireUnproposed(groupBinding.getGroupId());
                    LocalGroupingHandler.this.sendUnproposal(groupBinding.getGroupId(), groupBinding.getClusterName(), 0);
                    ++expiredGroups;
                    try {
                        if (txID < 0L) {
                            txID = LocalGroupingHandler.this.storageManager.generateID();
                        }
                        LocalGroupingHandler.this.storageManager.deleteGrouping(txID, groupBinding);
                        if (expiredGroups < 1000 || txID < 0L) continue;
                        LocalGroupingHandler.this.storageManager.commitBindings(txID);
                        expiredGroups = 0;
                        txID = -1L;
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeleteGroupBindings(groupBinding.getGroupId(), e);
                    }
                }
                if (txID >= 0L) {
                    try {
                        LocalGroupingHandler.this.storageManager.commitBindings(txID);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeleteGroupBindings(SimpleString.of((String)("TX:" + txID)), e);
                    }
                }
            }
        }
    }
}

