/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.help;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.VersionInfo;
import org.apache.rat.commandline.Arg;

public abstract class AbstractHelp {
    private static final String END_OF_OPTION_MSG = " Multiple values may be specified. Note that '--' or a following option is required when using this parameter.";
    public static final int HELP_WIDTH = 120;
    public static final int HELP_PADDING = 4;
    protected final RatHelpFormatter helpFormatter = new RatHelpFormatter();
    protected final VersionInfo versionInfo = new VersionInfo();
    public static final Function<Option, String> DEPRECATED_MSG = o -> {
        StringBuilder sb = new StringBuilder("[").append(o.getDeprecated().toString()).append("]");
        if (o.getDescription() != null) {
            sb.append(" ").append(o.getDescription());
        }
        return sb.toString();
    };

    protected AbstractHelp() {
    }

    public static String createPadding(int len) {
        char[] padding = new char[len];
        Arrays.fill(padding, ' ');
        return new String(padding);
    }

    public static String header(String txt) {
        return String.format("%n====== %s ======%n", WordUtils.capitalizeFully(txt));
    }

    public class RatHelpFormatter
    extends HelpFormatter {
        RatHelpFormatter() {
            this.optionComparator = OptionCollection.OPTION_COMPARATOR;
            this.setWidth(120);
        }

        public void printHelp(PrintWriter writer, String cmdLineSyntax, String header, Options options, String footer) {
            if (StringUtils.isEmpty(cmdLineSyntax)) {
                throw new IllegalArgumentException("cmdLineSyntax not provided");
            }
            AbstractHelp.this.helpFormatter.printUsage(writer, 120, cmdLineSyntax);
            if (header != null && !header.isEmpty()) {
                AbstractHelp.this.helpFormatter.printWrapped(writer, 120, header);
            }
            this.printOptions(writer, 120, options, AbstractHelp.this.helpFormatter.getLeftPadding(), AbstractHelp.this.helpFormatter.getDescPadding());
            if (footer != null && !footer.isEmpty()) {
                AbstractHelp.this.helpFormatter.printWrapped(writer, AbstractHelp.this.helpFormatter.getWidth(), footer);
            }
        }

        @Override
        protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
            String lpad = this.createPadding(leftPad);
            String dpad = this.createPadding(descPad);
            int max = 0;
            ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
            ArrayList<Option> optList = new ArrayList<Option>(options.getOptions());
            optList.sort(AbstractHelp.this.helpFormatter.getOptionComparator());
            for (Option option : optList) {
                StringBuffer optBuf = new StringBuffer();
                if (option.getOpt() == null) {
                    optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
                } else {
                    optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                    if (option.hasLongOpt()) {
                        optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                    }
                }
                if (option.hasArg()) {
                    String argName = option.getArgName();
                    if (argName != null && argName.isEmpty()) {
                        optBuf.append(' ');
                    } else {
                        optBuf.append(option.hasLongOpt() ? AbstractHelp.this.helpFormatter.getLongOptSeparator() : " ");
                        optBuf.append("<").append(argName != null ? option.getArgName() : this.getArgName()).append(">");
                    }
                }
                prefixList.add(optBuf);
                max = Math.max(optBuf.length(), max);
            }
            int x = 0;
            Iterator it = optList.iterator();
            while (it.hasNext()) {
                Arg arg;
                String defaultValue;
                StringBuilder optBuf;
                Option option = (Option)it.next();
                if ((optBuf = new StringBuilder(((StringBuffer)prefixList.get(x++)).toString())).length() < max) {
                    optBuf.append(this.createPadding(max - optBuf.length()));
                }
                optBuf.append(dpad);
                int nextLineTabStop = max + descPad;
                if (option.isDeprecated()) {
                    optBuf.append(DEPRECATED_MSG.apply(option).trim());
                } else if (option.getDescription() != null) {
                    optBuf.append(option.getDescription());
                }
                if (option.hasArgs()) {
                    optBuf.append(AbstractHelp.END_OF_OPTION_MSG);
                }
                String string = defaultValue = (arg = Arg.findArg(option)) == null ? null : arg.defaultValue();
                if (defaultValue != null) {
                    optBuf.append(String.format(" (Default value = %s)", defaultValue));
                }
                this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
                if (!it.hasNext()) continue;
                sb.append(this.getNewLine());
            }
            return sb;
        }
    }
}

